/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.commands.subcommands;

import io.github.thebusybiscuit.slimefun4.core.commands.SlimefunCommand;
import io.github.thebusybiscuit.slimefun4.core.commands.SubCommand;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceInspector;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.inspectors.ConsolePerformanceInspector;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.inspectors.PlayerPerformanceInspector;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

class TimingsCommand
extends SubCommand {
    private static final String FLAG_PREFIX = "--";
    private final Set<String> flags = new HashSet<String>(Arrays.asList("verbose"));

    TimingsCommand(SlimefunPlugin plugin, SlimefunCommand cmd) {
        super(plugin, cmd, "timings", false);
    }

    @Override
    protected String getDescription() {
        return "commands.timings.description";
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (sender.hasPermission("slimefun.command.timings") || sender instanceof ConsoleCommandSender) {
            if (this.hasInvalidFlags(sender, args)) {
                return;
            }
            boolean verbose = this.hasFlag(args, "verbose");
            if (verbose && sender instanceof Player) {
                SlimefunPlugin.getLocalization().sendMessage(sender, "commands.timings.verbose-player", true);
                return;
            }
            SlimefunPlugin.getLocalization().sendMessage(sender, "commands.timings.please-wait", true);
            PerformanceInspector inspector = this.inspectorOf(sender, verbose);
            SlimefunPlugin.getProfiler().requestSummary(inspector);
        } else {
            SlimefunPlugin.getLocalization().sendMessage(sender, "messages.no-permission", true);
        }
    }

    @ParametersAreNonnullByDefault
    private boolean hasInvalidFlags(CommandSender sender, String[] args) {
        boolean hasInvalidFlags = false;
        for (int i = 1; i < args.length; ++i) {
            String argument = args[i].toLowerCase(Locale.ROOT);
            if (!argument.startsWith(FLAG_PREFIX) || this.flags.contains(argument.substring(2))) continue;
            hasInvalidFlags = true;
            SlimefunPlugin.getLocalization().sendMessage(sender, "commands.timings.unknown-flag", true, msg -> msg.replace("%flag%", argument));
        }
        return hasInvalidFlags;
    }

    @ParametersAreNonnullByDefault
    private boolean hasFlag(String[] args, String flag) {
        for (int i = 1; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(FLAG_PREFIX + flag)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private PerformanceInspector inspectorOf(@Nonnull CommandSender sender, boolean verbose) {
        if (sender instanceof Player) {
            return new PlayerPerformanceInspector((Player)sender);
        }
        return new ConsolePerformanceInspector(sender, verbose);
    }
}

