/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.config;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Config {
    private File file;
    private String header;
    private Logger logger;
    protected FileConfiguration fileConfig;

    public Config(@NonNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        plugin.getConfig().options().copyDefaults(true);
        plugin.saveConfig();
        this.logger = plugin.getLogger();
        this.file = new File("plugins/" + plugin.getName().replace(" ", "_"), "config.yml");
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        this.fileConfig.options().copyDefaults(true);
    }

    public Config(@NonNull Plugin plugin, @NonNull String name) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.logger = plugin.getLogger();
        this.file = new File("plugins/" + plugin.getName().replace(" ", "_"), name);
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        this.fileConfig.options().copyDefaults(true);
    }

    public Config(@NonNull File file, @NonNull FileConfiguration config) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.logger = Logger.getLogger("CS-CoreLib2");
        this.file = file;
        this.fileConfig = config;
        config.options().copyDefaults(true);
    }

    public Config(@NonNull File file) {
        this(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
    }

    public Config(@NonNull String path) {
        this(new File(path));
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
    }

    @Nonnull
    public FileConfiguration getConfiguration() {
        return this.fileConfig;
    }

    public void setLogger(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.logger = logger;
    }

    public void clear() {
        for (String key : this.getKeys()) {
            this.setValue(key, null);
        }
    }

    protected void store(@NonNull String path, Object value) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.fileConfig.set(path, value);
    }

    public void setValue(@NonNull String path, Object value) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (value == null) {
            this.store(path, value);
        } else if (value instanceof Optional) {
            this.store(path, ((Optional)value).orElse(null));
        } else if (value instanceof Inventory) {
            this.store(path + ".size", ((Inventory)value).getSize());
            for (int i = 0; i < ((Inventory)value).getSize(); ++i) {
                this.store(path + "." + i, ((Inventory)value).getItem(i));
            }
        } else if (value instanceof Date) {
            this.store(path, String.valueOf(((Date)value).getTime()));
        } else if (value instanceof Long) {
            this.store(path, String.valueOf(value));
        } else if (value instanceof UUID) {
            this.store(path, value.toString());
        } else if (value instanceof Sound) {
            this.store(path, String.valueOf(value));
        } else if (value instanceof Location) {
            this.store(path + ".x", ((Location)value).getX());
            this.store(path + ".y", ((Location)value).getY());
            this.store(path + ".z", ((Location)value).getZ());
            this.store(path + ".pitch", Float.valueOf(((Location)value).getPitch()));
            this.store(path + ".yaw", Float.valueOf(((Location)value).getYaw()));
            this.store(path + ".world", ((Location)value).getWorld().getName());
        } else if (value instanceof Chunk) {
            this.store(path + ".x", ((Chunk)value).getX());
            this.store(path + ".z", ((Chunk)value).getZ());
            this.store(path + ".world", ((Chunk)value).getWorld().getName());
        } else if (value instanceof World) {
            this.store(path, ((World)value).getName());
        } else {
            this.store(path, value);
        }
    }

    public void save() {
        this.save(this.file);
    }

    public void save(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            if (this.header != null) {
                this.fileConfig.options().copyHeader(true);
                this.fileConfig.options().header(this.header);
            } else {
                this.fileConfig.options().copyHeader(false);
            }
            this.fileConfig.save(file);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception while saving a Config file", e);
        }
    }

    public void setDefaultValue(@NonNull String path, @Nullable Object value) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (!this.contains(path)) {
            this.setValue(path, value);
        }
    }

    public <T> T getOrSetDefault(@NonNull String path, T value) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Object val = this.getValue(path);
        if (value.getClass().isInstance(val)) {
            return (T)val;
        }
        this.setValue(path, value);
        return value;
    }

    public boolean contains(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.contains(path);
    }

    @Nullable
    public Object getValue(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.get(path);
    }

    @Nonnull
    public <T> Optional<T> getValueAs(@NonNull Class<T> c, @NonNull String path) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        Object obj = this.getValue(path);
        return c.isInstance(obj) ? Optional.of(c.cast(obj)) : Optional.empty();
    }

    @Nullable
    public ItemStack getItem(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.getItemStack(path);
    }

    @Nullable
    public String getString(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.getString(path);
    }

    public int getInt(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.getInt(path);
    }

    public boolean getBoolean(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.getBoolean(path);
    }

    @Nonnull
    public List<String> getStringList(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.getStringList(path);
    }

    @Nonnull
    public List<Integer> getIntList(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.getIntegerList(path);
    }

    public boolean createFile() {
        try {
            return this.file.createNewFile();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception while creating a Config file", e);
            return false;
        }
    }

    public float getFloat(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Float.valueOf(String.valueOf(this.getValue(path))).floatValue();
    }

    public long getLong(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Long.valueOf(String.valueOf(this.getValue(path)));
    }

    @Deprecated
    public Sound getSound(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Sound.valueOf((String)this.getString(path));
    }

    public Date getDate(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new Date(this.getLong(path));
    }

    public Chunk getChunk(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Bukkit.getWorld((String)this.getString(path + ".world")).getChunkAt(this.getInt(path + ".x"), this.getInt(path + ".z"));
    }

    public UUID getUUID(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String value = this.getString(path);
        return value != null ? UUID.fromString(value) : null;
    }

    public World getWorld(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Bukkit.getWorld((String)this.getString(path));
    }

    public double getDouble(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.fileConfig.getDouble(path);
    }

    @Nonnull
    public Location getLocation(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return new Location(Bukkit.getWorld((String)this.getString(path + ".world")), this.getDouble(path + ".x"), this.getDouble(path + ".y"), this.getDouble(path + ".z"), this.getFloat(path + ".yaw"), this.getFloat(path + ".pitch"));
    }

    @Nonnull
    public Inventory getInventory(@NonNull String path, int size, @NonNull String title) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        for (int i = 0; i < size; ++i) {
            inventory.setItem(i, this.getItem(path + "." + i));
        }
        return inventory;
    }

    @Nonnull
    public Inventory getInventory(@NonNull String path, @NonNull String title) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        int size = this.getInt(path + ".size");
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        for (int i = 0; i < size; ++i) {
            inventory.setItem(i, this.getItem(path + "." + i));
        }
        return inventory;
    }

    @Nonnull
    public Set<String> getKeys() {
        return this.fileConfig.getKeys(false);
    }

    @Nonnull
    public Set<String> getKeys(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        ConfigurationSection section = this.fileConfig.getConfigurationSection(path);
        return section == null ? new HashSet() : section.getKeys(false);
    }

    public void reload() {
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

