/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.magical.talismans.Talisman;
import io.github.thebusybiscuit.slimefun4.implementation.settings.TalismanEnchantment;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class MagicianTalisman
extends Talisman {
    private final ItemSetting<Boolean> allowEnchantmentBooks = new ItemSetting<Boolean>("allow-enchantment-books", false);
    private final Set<TalismanEnchantment> enchantments = new HashSet<TalismanEnchantment>();

    @ParametersAreNonnullByDefault
    public MagicianTalisman(SlimefunItemStack item, ItemStack[] recipe) {
        super(item, recipe, false, false, "magician", 80, new PotionEffect[0]);
        this.addItemSetting(this.allowEnchantmentBooks);
        for (Enchantment enchantment : Enchantment.values()) {
            try {
                for (int i = 1; i <= enchantment.getMaxLevel(); ++i) {
                    this.enchantments.add(new TalismanEnchantment(enchantment, i));
                }
            }
            catch (Exception x) {
                SlimefunPlugin.logger().log(Level.SEVERE, x, () -> "The following Exception occurred while trying to register the following Enchantment: " + enchantment);
            }
        }
        if (!this.enchantments.isEmpty()) {
            this.addItemSetting(this.enchantments.toArray(new ItemSetting[0]));
        }
    }

    @Nullable
    public TalismanEnchantment getRandomEnchantment(@Nonnull ItemStack item, @Nonnull Set<Enchantment> existingEnchantments) {
        Validate.notNull((Object)item, (String)"The ItemStack cannot be null");
        Validate.notNull(existingEnchantments, (String)"The Enchantments Set cannot be null");
        List enabled = this.enchantments.stream().filter(e -> this.isEnchantmentBookAllowed() && item.getType() == Material.BOOK || e.getEnchantment().canEnchantItem(item)).filter(e -> this.hasConflicts(existingEnchantments, (TalismanEnchantment)e)).filter(ItemSetting::getValue).collect(Collectors.toList());
        return enabled.isEmpty() ? null : (TalismanEnchantment)enabled.get(ThreadLocalRandom.current().nextInt(enabled.size()));
    }

    @ParametersAreNonnullByDefault
    private boolean hasConflicts(Set<Enchantment> enchantments, TalismanEnchantment ench) {
        for (Enchantment existing : enchantments) {
            if (!existing.conflictsWith(ench.getEnchantment())) continue;
            return false;
        }
        return true;
    }

    public boolean isEnchantmentBookAllowed() {
        return this.allowEnchantmentBooks.getValue();
    }
}

