/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.magical.runes;

import io.github.thebusybiscuit.slimefun4.core.handlers.ItemDropHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Collection;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SoulboundRune
extends SimpleSlimefunItem<ItemDropHandler> {
    private static final double RANGE = 1.5;

    public SoulboundRune(Category category, SlimefunItemStack item, RecipeType type, ItemStack[] recipe) {
        super(category, item, type, recipe);
    }

    @Override
    public ItemDropHandler getItemHandler() {
        return (e, p, item) -> {
            if (this.isItem(item.getItemStack())) {
                if (!Slimefun.hasUnlocked(p, this, true)) {
                    return true;
                }
                SlimefunPlugin.runSync(() -> this.activate(p, item), 20L);
                return true;
            }
            return false;
        };
    }

    private void activate(Player p, Item rune) {
        if (!rune.isValid()) {
            return;
        }
        Location l = rune.getLocation();
        Collection entites = l.getWorld().getNearbyEntities(l, 1.5, 1.5, 1.5, this::findCompatibleItem);
        Optional optional = entites.stream().findFirst();
        if (optional.isPresent()) {
            Item item = (Item)optional.get();
            ItemStack itemStack = item.getItemStack();
            if (itemStack.getAmount() == 1) {
                l.getWorld().strikeLightningEffect(l);
                SlimefunPlugin.runSync(() -> {
                    if (rune.isValid() && item.isValid() && itemStack.getAmount() == 1) {
                        l.getWorld().createExplosion(l, 0.0f);
                        l.getWorld().playSound(l, Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 1.0f);
                        item.remove();
                        rune.remove();
                        SlimefunUtils.setSoulbound(itemStack, true);
                        l.getWorld().dropItemNaturally(l, itemStack);
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.soulbound-rune.success", true);
                    } else {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.soulbound-rune.fail", true);
                    }
                }, 10L);
            } else {
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.soulbound-rune.fail", true);
            }
        }
    }

    private boolean findCompatibleItem(Entity entity) {
        if (entity instanceof Item) {
            Item item = (Item)entity;
            return !SlimefunUtils.isSoulbound(item.getItemStack()) && !this.isItem(item.getItemStack());
        }
        return false;
    }
}

