/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.altar;

import io.github.thebusybiscuit.slimefun4.core.handlers.BlockDispenseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class AncientPedestal
extends SimpleSlimefunItem<BlockDispenseHandler> {
    public static final String ITEM_PREFIX = ChatColors.color("&dALTAR &3Probe - &e");

    @ParametersAreNonnullByDefault
    public AncientPedestal(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        super(category, item, recipeType, recipe, recipeOutput);
        SlimefunItem.registerBlockHandler(this.getId(), (p, b, tool, reason) -> {
            Item stack;
            Optional<Item> entity = this.getPlacedItem(b);
            if (entity.isPresent() && (stack = entity.get()).isValid()) {
                stack.removeMetadata("no_pickup", (Plugin)SlimefunPlugin.instance());
                b.getWorld().dropItem(b.getLocation(), this.getOriginalItemStack(stack));
                stack.remove();
            }
            return true;
        });
    }

    @Override
    public BlockDispenseHandler getItemHandler() {
        return (e, d, block, machine) -> e.setCancelled(true);
    }

    @Nonnull
    public Optional<Item> getPlacedItem(@Nonnull Block pedestal) {
        Location l = pedestal.getLocation().add(0.5, 1.2, 0.5);
        for (Entity n : l.getWorld().getNearbyEntities(l, 0.5, 0.5, 0.5, this::testItem)) {
            if (!(n instanceof Item)) continue;
            return Optional.of((Item)n);
        }
        return Optional.empty();
    }

    private boolean testItem(@Nullable Entity n) {
        if (n instanceof Item && n.isValid()) {
            Item item = (Item)n;
            ItemMeta meta = item.getItemStack().getItemMeta();
            return meta.hasDisplayName() && meta.getDisplayName().startsWith(ITEM_PREFIX);
        }
        return false;
    }

    @Nonnull
    public ItemStack getOriginalItemStack(@Nonnull Item item) {
        ItemStack stack = item.getItemStack().clone();
        String customName = item.getCustomName();
        if (customName.equals(ItemUtils.getItemName(new ItemStack(stack.getType())))) {
            ItemMeta im = stack.getItemMeta();
            im.setDisplayName(null);
            stack.setItemMeta(im);
        } else {
            ItemMeta im = stack.getItemMeta();
            if (!customName.startsWith(String.valueOf('\u00a7'))) {
                customName = ChatColor.WHITE + customName;
            }
            im.setDisplayName(customName);
            stack.setItemMeta(im);
        }
        return stack;
    }

    public void placeItem(@Nonnull Player p, @Nonnull Block b) {
        ItemStack hand = p.getInventory().getItemInMainHand();
        CustomItem displayItem = new CustomItem(hand, ITEM_PREFIX + System.nanoTime(), new String[0]);
        displayItem.setAmount(1);
        String nametag = ItemUtils.getItemName(hand);
        if (p.getGameMode() != GameMode.CREATIVE) {
            ItemUtils.consumeItem(hand, false);
        }
        Item entity = b.getWorld().dropItem(b.getLocation().add(0.5, 1.2, 0.5), (ItemStack)displayItem);
        entity.setVelocity(new Vector(0.0, 0.1, 0.0));
        entity.setCustomNameVisible(true);
        entity.setCustomName(nametag);
        SlimefunUtils.markAsNoPickup(entity, "altar_item");
        p.playSound(b.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.3f, 0.3f);
    }
}

