/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.config;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Config {
    private File file;
    protected FileConfiguration fileConfig;

    public Config(Plugin plugin) {
        plugin.saveDefaultConfig();
        this.file = new File("plugins/" + plugin.getName().replace(" ", "_"), "config.yml");
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        this.fileConfig.options().copyDefaults(true);
    }

    public Config(Plugin plugin, String name) {
        this.file = new File("plugins/" + plugin.getName().replace(" ", "_"), name);
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        this.fileConfig.options().copyDefaults(true);
    }

    public Config(File file) {
        this.file = file;
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        this.fileConfig.options().copyDefaults(true);
    }

    public Config(File file, FileConfiguration config) {
        this.file = file;
        this.fileConfig = config;
        config.options().copyDefaults(true);
    }

    public Config(String path) {
        this.file = new File(path);
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
        this.fileConfig.options().copyDefaults(true);
    }

    public FileConfiguration getConfiguration() {
        return this.fileConfig;
    }

    protected void store(String path, Object value) {
        this.fileConfig.set(path, value);
    }

    public void setValue(String path, Object value) {
        if (value == null) {
            this.store(path, value);
        } else if (value instanceof Inventory) {
            this.store(path + ".size", ((Inventory)value).getSize());
            for (int i = 0; i < ((Inventory)value).getSize(); ++i) {
                this.store(path + "." + i, ((Inventory)value).getItem(i));
            }
        } else if (value instanceof Date) {
            this.store(path, String.valueOf(((Date)value).getTime()));
        } else if (value instanceof Long) {
            this.store(path, String.valueOf(value));
        } else if (value instanceof UUID) {
            this.store(path, value.toString());
        } else if (value instanceof Sound) {
            this.store(path, String.valueOf(value));
        } else if (value instanceof Location) {
            this.store(path + ".x", ((Location)value).getX());
            this.store(path + ".y", ((Location)value).getY());
            this.store(path + ".z", ((Location)value).getZ());
            this.store(path + ".pitch", Float.valueOf(((Location)value).getPitch()));
            this.store(path + ".yaw", Float.valueOf(((Location)value).getYaw()));
            this.store(path + ".world", ((Location)value).getWorld().getName());
        } else if (value instanceof Chunk) {
            this.store(path + ".x", ((Chunk)value).getX());
            this.store(path + ".z", ((Chunk)value).getZ());
            this.store(path + ".world", ((Chunk)value).getWorld().getName());
        } else if (value instanceof World) {
            this.store(path, ((World)value).getName());
        } else {
            this.store(path, value);
        }
    }

    public void save() {
        try {
            this.fileConfig.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(File file) {
        try {
            this.fileConfig.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDefaultValue(String path, Object value) {
        if (!this.contains(path)) {
            this.setValue(path, value);
        }
    }

    public <T> T getOrSetDefault(String path, T value) {
        Object val = this.getValue(path);
        if (value.getClass().isInstance(val)) {
            return (T)val;
        }
        this.setValue(path, value);
        return value;
    }

    public boolean contains(String path) {
        return this.fileConfig.contains(path);
    }

    public Object getValue(String path) {
        return this.fileConfig.get(path);
    }

    public ItemStack getItem(String path) {
        return this.fileConfig.getItemStack(path);
    }

    public String getString(String path) {
        return this.fileConfig.getString(path);
    }

    public int getInt(String path) {
        return this.fileConfig.getInt(path);
    }

    public boolean getBoolean(String path) {
        return this.fileConfig.getBoolean(path);
    }

    public List<String> getStringList(String path) {
        return this.fileConfig.getStringList(path);
    }

    public List<Integer> getIntList(String path) {
        return this.fileConfig.getIntegerList(path);
    }

    public boolean createFile() {
        try {
            return this.file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Float getFloat(String path) {
        return Float.valueOf(String.valueOf(this.getValue(path)));
    }

    public Long getLong(String path) {
        return Long.valueOf(String.valueOf(this.getValue(path)));
    }

    public Sound getSound(String path) {
        return Sound.valueOf((String)this.getString(path));
    }

    public Date getDate(String path) {
        return new Date(this.getLong(path));
    }

    public Chunk getChunk(String path) {
        return Bukkit.getWorld((String)this.getString(path + ".world")).getChunkAt(this.getInt(path + ".x"), this.getInt(path + ".z"));
    }

    public UUID getUUID(String path) {
        return UUID.fromString(this.getString(path));
    }

    public World getWorld(String path) {
        return Bukkit.getWorld((String)this.getString(path));
    }

    public Double getDouble(String path) {
        return this.fileConfig.getDouble(path);
    }

    public Location getLocation(String path) {
        return new Location(Bukkit.getWorld((String)this.getString(path + ".world")), this.getDouble(path + ".x").doubleValue(), this.getDouble(path + ".y").doubleValue(), this.getDouble(path + ".z").doubleValue(), this.getFloat(path + ".yaw").floatValue(), this.getFloat(path + ".pitch").floatValue());
    }

    public Inventory getInventory(String path, int size, String title) {
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        for (int i = 0; i < size; ++i) {
            inventory.setItem(i, this.getItem(path + "." + i));
        }
        return inventory;
    }

    public Inventory getInventory(String path, String title) {
        int size = this.getInt(path + ".size");
        Inventory inventory = Bukkit.createInventory(null, (int)size, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        for (int i = 0; i < size; ++i) {
            inventory.setItem(i, this.getItem(path + "." + i));
        }
        return inventory;
    }

    public Set<String> getKeys() {
        return this.fileConfig.getKeys(false);
    }

    public Set<String> getKeys(String path) {
        ConfigurationSection section = this.fileConfig.getConfigurationSection(path);
        return section == null ? new HashSet() : section.getKeys(false);
    }

    public void reload() {
        this.fileConfig = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public File getFile() {
        return this.file;
    }
}

