/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest.apache;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.AsyncClient;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Config;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpRequest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpRequestSummary;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.MetricContext;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.RawResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.ApacheAsyncConfig;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.ApacheResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.AsyncIdleConnectionMonitorThread;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.BaseApacheClient;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.RequestConfigFactory;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.RequestPrep;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;

public class ApacheAsyncClient
extends BaseApacheClient
implements AsyncClient {
    private ApacheAsyncConfig apache;

    public ApacheAsyncClient(Config config) {
        this.apache = new ApacheAsyncConfig(config);
    }

    public ApacheAsyncClient(HttpAsyncClient client, Config config) {
        this.apache = new ApacheAsyncConfig(client, config);
    }

    @Deprecated
    public ApacheAsyncClient(HttpAsyncClient client, Config config, PoolingNHttpClientConnectionManager manager, AsyncIdleConnectionMonitorThread monitor) {
        this.apache = new ApacheAsyncConfig(client, config, manager, monitor);
    }

    @Override
    public void registerShutdownHook() {
        this.apache.registerShutdownHook();
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, final Function<RawResponse, HttpResponse<T>> transformer, final CompletableFuture<HttpResponse<T>> callback) {
        Objects.requireNonNull(callback);
        this.apache.config.getUniInterceptor().onRequest(request, this.apache.config);
        HttpRequestBase requestObj = new RequestPrep(request, this.apache.config, true).prepare(this.configFactory);
        final HttpRequestSummary reqSum = request.toSummary();
        final MetricContext metric = this.apache.config.getMetric().begin(reqSum);
        HttpHost host = ApacheAsyncClient.determineTarget(requestObj, request.getHeaders());
        this.apache.client.execute(new BasicAsyncRequestProducer(host, requestObj), new BasicAsyncResponseConsumer(), new FutureCallback<org.apache.http.HttpResponse>(){

            @Override
            public void completed(org.apache.http.HttpResponse httpResponse) {
                ApacheResponse t = new ApacheResponse(httpResponse, ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config);
                metric.complete(t.toSummary(), null);
                HttpResponse response = ApacheAsyncClient.this.transformBody(transformer, t);
                ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config.getUniInterceptor().onResponse(response, reqSum, ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config);
                callback.complete(response);
            }

            @Override
            public void failed(Exception e) {
                metric.complete(null, e);
                try {
                    HttpResponse<?> r = ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config.getUniInterceptor().onFail(e, reqSum, ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config);
                    callback.complete(r);
                }
                catch (Exception ee) {
                    callback.completeExceptionally(e);
                }
            }

            @Override
            public void cancelled() {
                UnirestException canceled = new UnirestException("canceled");
                metric.complete(null, canceled);
                callback.completeExceptionally(canceled);
                ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config.getUniInterceptor().onFail(canceled, reqSum, ((ApacheAsyncClient)ApacheAsyncClient.this).apache.config);
            }
        });
        return callback;
    }

    @Override
    public boolean isRunning() {
        return this.apache.isRunning();
    }

    public HttpAsyncClient getClient() {
        return this.apache.getClient();
    }

    @Override
    public Stream<Exception> close() {
        return this.apache.close();
    }

    public static Builder builder(HttpAsyncClient client) {
        return new Builder(client);
    }

    public static class Builder
    implements Function<Config, AsyncClient> {
        private HttpAsyncClient asyncClient;
        private RequestConfigFactory cf;

        public Builder(HttpAsyncClient client) {
            this.asyncClient = client;
        }

        @Override
        public AsyncClient apply(Config config) {
            ApacheAsyncClient client = new ApacheAsyncClient(this.asyncClient, config);
            if (this.cf != null) {
                client.setConfigFactory(this.cf);
            }
            return client;
        }

        public Builder withRequestConfig(RequestConfigFactory factory) {
            Objects.requireNonNull(factory);
            this.cf = factory;
            return this;
        }
    }
}

