/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.MultiBlockInteractionHandler;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlock;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class MultiBlockMachine
extends SlimefunItem
implements NotPlaceable,
RecipeDisplayItem {
    private static final BlockFace[] outputFaces = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    protected final List<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
    protected final List<ItemStack> displayRecipes = new ArrayList<ItemStack>();
    protected final MultiBlock multiblock;

    public MultiBlockMachine(Category category, SlimefunItemStack item, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger) {
        super(category, item, RecipeType.MULTIBLOCK, recipe);
        this.displayRecipes.addAll(Arrays.asList(machineRecipes));
        this.multiblock = new MultiBlock(this, MultiBlockMachine.convertItemStacksToMaterial(recipe), trigger);
        this.registerDefaultRecipes(this.displayRecipes);
    }

    public MultiBlockMachine(Category category, SlimefunItemStack item, ItemStack[] recipe, BlockFace trigger) {
        this(category, item, recipe, new ItemStack[0], trigger);
    }

    protected void registerDefaultRecipes(@Nonnull List<ItemStack> recipes) {
    }

    public List<ItemStack[]> getRecipes() {
        return this.recipes;
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.displayRecipes;
    }

    @Nonnull
    public MultiBlock getMultiBlock() {
        return this.multiblock;
    }

    public void addRecipe(ItemStack[] input, ItemStack output) {
        Validate.notNull((Object)output, (String)"Recipes must have an Output!");
        this.recipes.add(input);
        this.recipes.add(new ItemStack[]{output});
    }

    @Override
    public void register(@Nonnull SlimefunAddon addon) {
        this.addItemHandler(this.getInteractionHandler());
        super.register(addon);
    }

    @Override
    public void postRegister() {
        SlimefunPlugin.getRegistry().getMultiBlocks().add(this.multiblock);
    }

    @Override
    public void load() {
        super.load();
        for (ItemStack recipeItem : this.displayRecipes) {
            SlimefunItem item = SlimefunItem.getByItem(recipeItem);
            if (item != null && item.isDisabled()) continue;
            this.recipes.add(new ItemStack[]{recipeItem});
        }
    }

    protected MultiBlockInteractionHandler getInteractionHandler() {
        return (p, mb, b) -> {
            if (mb.equals(this.getMultiBlock())) {
                if (!this.isDisabled() && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.INTERACT_BLOCK) && Slimefun.hasUnlocked(p, this, true)) {
                    this.onInteract(p, b);
                }
                return true;
            }
            return false;
        };
    }

    public abstract void onInteract(Player var1, Block var2);

    protected Inventory findOutputInventory(ItemStack adding, Block dispBlock, Inventory dispInv) {
        return this.findOutputInventory(adding, dispBlock, dispInv, dispInv);
    }

    protected Inventory findOutputInventory(ItemStack product, Block dispBlock, Inventory dispInv, Inventory placeCheckerInv) {
        Inventory outputInv = this.findOutputChest(dispBlock, product);
        if (outputInv == null && InvUtils.fits(placeCheckerInv, product, new int[0])) {
            return dispInv;
        }
        return outputInv;
    }

    @Nullable
    protected Inventory findOutputChest(@Nonnull Block b, @Nonnull ItemStack output) {
        for (BlockFace face : outputFaces) {
            Inventory inv;
            BlockState state;
            String id;
            Block potentialOutput = b.getRelative(face);
            if (potentialOutput.getType() != Material.CHEST || (id = BlockStorage.checkID(potentialOutput)) == null || !id.equals("OUTPUT_CHEST") || !((state = PaperLib.getBlockState(potentialOutput, false).getState()) instanceof Chest) || !InvUtils.fits(inv = ((Chest)state).getInventory(), output, new int[0])) continue;
            return inv;
        }
        return null;
    }

    @Nonnull
    private static Material[] convertItemStacksToMaterial(ItemStack[] items) {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (ItemStack item : items) {
            if (item == null) {
                materials.add(null);
                continue;
            }
            if (item.getType() == Material.FLINT_AND_STEEL) {
                materials.add(Material.FIRE);
                continue;
            }
            materials.add(item.getType());
        }
        return materials.toArray(new Material[0]);
    }
}

