/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.ItemManipulationEvent;
import me.mrCookieSlime.Slimefun.api.inventory.MenuSavingHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class DirtyChestMenu
extends ChestMenu {
    protected final BlockMenuPreset preset;
    protected ItemManipulationEvent event;
    protected int changes = 1;

    public DirtyChestMenu(@Nonnull BlockMenuPreset preset) {
        super(preset.getTitle());
        this.preset = preset;
    }

    public boolean hasViewer() {
        Inventory inv = this.toInventory();
        return inv != null && !inv.getViewers().isEmpty();
    }

    public void markDirty() {
        ++this.changes;
    }

    public boolean isDirty() {
        return this.changes > 0;
    }

    public int getUnsavedChanges() {
        return this.changes;
    }

    @Nonnull
    public BlockMenuPreset getPreset() {
        return this.preset;
    }

    public boolean canOpen(Block b, Player p) {
        return this.preset.canOpen(b, p);
    }

    public void close() {
        for (HumanEntity human : new ArrayList(this.toInventory().getViewers())) {
            human.closeInventory();
        }
    }

    @Deprecated
    public void registerEvent(ItemManipulationEvent event) {
        this.event = event;
    }

    public ChestMenu addMenuOpeningHandler(ChestMenu.MenuOpeningHandler handler) {
        if (handler instanceof MenuSavingHandler) {
            ChestMenu.MenuOpeningHandler openingHandler = ((MenuSavingHandler)handler).getOpeningHandler();
            return super.addMenuOpeningHandler((ChestMenu.MenuOpeningHandler)new MenuSavingHandler(this, openingHandler));
        }
        return super.addMenuOpeningHandler((ChestMenu.MenuOpeningHandler)new MenuSavingHandler(this, handler));
    }

    public boolean fits(@Nonnull ItemStack item, int ... slots) {
        for (int slot : slots) {
            if (this.getItemInSlot(slot) != null) continue;
            return true;
        }
        return InvUtils.fits(this.toInventory(), new ItemStackWrapper(item), slots);
    }

    @Nullable
    public ItemStack pushItem(ItemStack item, int ... slots) {
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("Cannot push null or AIR");
        }
        ItemStackWrapper wrapper = null;
        int amount = item.getAmount();
        for (int slot : slots) {
            if (amount <= 0) break;
            ItemStack stack = this.getItemInSlot(slot);
            if (stack == null) {
                this.replaceExistingItem(slot, item);
                return null;
            }
            if (stack.getAmount() >= stack.getMaxStackSize()) continue;
            if (wrapper == null) {
                wrapper = new ItemStackWrapper(item);
            }
            if (!ItemUtils.canStack(wrapper, stack)) continue;
            stack.setAmount(Math.min(stack.getAmount() + item.getAmount(), stack.getMaxStackSize()));
            item.setAmount(amount -= stack.getMaxStackSize() - stack.getAmount());
        }
        if (amount > 0) {
            return new CustomItem(item, amount);
        }
        return null;
    }

    public void consumeItem(int slot) {
        this.consumeItem(slot, 1);
    }

    public void consumeItem(int slot, int amount) {
        this.consumeItem(slot, amount, false);
    }

    public void consumeItem(int slot, int amount, boolean replaceConsumables) {
        ItemUtils.consumeItem(this.getItemInSlot(slot), amount, replaceConsumables);
        this.markDirty();
    }

    public void replaceExistingItem(int slot, ItemStack item) {
        this.replaceExistingItem(slot, item, true);
    }

    public void replaceExistingItem(int slot, ItemStack item, boolean event) {
        if (event) {
            ItemStack previous = this.getItemInSlot(slot);
            if (this.event != null) {
                item = this.event.onEvent(slot, previous, item);
            }
            item = this.preset.onItemStackChange(this, slot, previous, item);
        }
        super.replaceExistingItem(slot, item);
        this.markDirty();
    }
}

