/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.Vein;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class FluidPump
extends SimpleSlimefunItem<BlockTicker>
implements InventoryBlock,
EnergyNetComponent {
    private static final int ENERGY_CONSUMPTION = 32;
    private static final int RANGE = 42;
    private final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44, 22};
    private final int[] inputBorder = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private final int[] outputBorder = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private final ItemStack emptyBucket = new ItemStackWrapper(Material.BUCKET);

    @ParametersAreNonnullByDefault
    public FluidPump(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.createPreset(this, this::constructMenu);
        FluidPump.registerBlockHandler(this.getId(), (p, b, stack, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                inv.dropItems(b.getLocation(), this.getInputSlots());
                inv.dropItems(b.getLocation(), this.getOutputSlots());
            }
            return true;
        });
    }

    private void constructMenu(@Nonnull BlockMenuPreset preset) {
        for (int i : this.border) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.inputBorder) {
            preset.addItem(i, ChestMenuUtils.getInputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.outputBorder) {
            preset.addItem(i, ChestMenuUtils.getOutputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{19, 20};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    @Override
    public int getCapacity() {
        return 512;
    }

    protected void tick(@Nonnull Block b) {
        Block fluid = b.getRelative(BlockFace.DOWN);
        if (fluid.isLiquid() && this.getCharge(b.getLocation()) >= 32) {
            BlockMenu menu = BlockStorage.getInventory(b);
            for (int slot : this.getInputSlots()) {
                if (!SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), this.emptyBucket, true, false)) continue;
                ItemStack bucket = this.getFilledBucket(fluid);
                if (!menu.fits(bucket, this.getOutputSlots())) {
                    return;
                }
                Block nextFluid = this.findNextFluid(fluid);
                if (nextFluid != null) {
                    this.removeCharge(b.getLocation(), 32);
                    menu.consumeItem(slot);
                    menu.pushItem(bucket, this.getOutputSlots());
                    nextFluid.setType(Material.AIR);
                }
                return;
            }
        }
    }

    @Nullable
    private Block findNextFluid(@Nonnull Block fluid) {
        if (fluid.getType() == Material.WATER || fluid.getType() == Material.BUBBLE_COLUMN) {
            if (this.isSource(fluid)) {
                return fluid;
            }
        } else if (fluid.getType() == Material.LAVA) {
            List<Block> list = Vein.find(fluid, 42, block -> block.getType() == fluid.getType());
            for (int i = list.size() - 1; i >= 0; --i) {
                Block block2 = list.get(i);
                if (!this.isSource(block2)) continue;
                return block2;
            }
        }
        return null;
    }

    @Nonnull
    private ItemStack getFilledBucket(@Nonnull Block fluid) {
        if (fluid.getType() == Material.LAVA) {
            return new ItemStack(Material.LAVA_BUCKET);
        }
        if (fluid.getType() == Material.WATER || fluid.getType() == Material.BUBBLE_COLUMN) {
            return new ItemStack(Material.WATER_BUCKET);
        }
        return new ItemStack(Material.BUCKET);
    }

    private boolean isSource(@Nonnull Block block) {
        BlockData data;
        if (block.isLiquid() && (data = block.getBlockData()) instanceof Levelled) {
            Levelled levelled = (Levelled)data;
            return levelled.getLevel() == 0;
        }
        return false;
    }

    @Override
    public BlockTicker getItemHandler() {
        return new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                FluidPump.this.tick(b);
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        };
    }
}

