/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractEntityAssembler<T extends Entity>
extends SimpleSlimefunItem<BlockTicker>
implements EnergyNetComponent {
    private static final String KEY_ENABLED = "enabled";
    private static final String KEY_OFFSET = "offset";
    private final int[] border = new int[]{0, 2, 3, 4, 5, 6, 8, 12, 14, 21, 23, 30, 32, 39, 40, 41};
    private final int[] inputSlots = new int[]{19, 28, 25, 34};
    private final int[] headSlots = new int[]{19, 28};
    private final int[] headBorder = new int[]{9, 10, 11, 18, 20, 27, 29, 36, 37, 38};
    private final int[] bodySlots = new int[]{25, 34};
    private final int[] bodyBorder = new int[]{15, 16, 17, 24, 26, 33, 35, 42, 43, 44};
    private int lifetime = 0;

    public AbstractEntityAssembler(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.getId(), item.getImmutableMeta().getDisplayName().orElse("Entity Assembler")){

            @Override
            public void init() {
                this.drawBackground(AbstractEntityAssembler.this.border);
                this.drawBackground(new CustomItem(AbstractEntityAssembler.this.getHeadBorder(), " ", new String[0]), AbstractEntityAssembler.this.headBorder);
                this.drawBackground(new CustomItem(AbstractEntityAssembler.this.getBodyBorder(), " ", new String[0]), AbstractEntityAssembler.this.bodyBorder);
                AbstractEntityAssembler.this.constructMenu(this);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                AbstractEntityAssembler.this.updateBlockInventory(menu, b);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.INTERACT_BLOCK);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return AbstractEntityAssembler.this.inputSlots;
                }
                return new int[0];
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.INSERT && item != null) {
                    if (item.getType() == AbstractEntityAssembler.this.getBody().getType()) {
                        return AbstractEntityAssembler.this.bodySlots;
                    }
                    if (item.getType() == AbstractEntityAssembler.this.getHead().getType()) {
                        return AbstractEntityAssembler.this.headSlots;
                    }
                }
                return new int[0];
            }
        };
        this.addItemHandler(this.onPlace());
        AbstractEntityAssembler.registerBlockHandler(this.getId(), (p, b, stack, reason) -> {
            if (reason == UnregisterReason.EXPLODE) {
                return false;
            }
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                inv.dropItems(b.getLocation(), this.headSlots);
                inv.dropItems(b.getLocation(), this.bodySlots);
            }
            return true;
        });
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(true){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                this.onPlace((BlockEvent)e);
            }

            @Override
            public void onBlockPlacerPlace(BlockPlacerPlaceEvent e) {
                this.onPlace(e);
            }

            private void onPlace(BlockEvent e) {
                BlockStorage.addBlockInfo(e.getBlock(), AbstractEntityAssembler.KEY_OFFSET, "3.0");
                BlockStorage.addBlockInfo(e.getBlock(), AbstractEntityAssembler.KEY_ENABLED, String.valueOf(false));
            }
        };
    }

    private void updateBlockInventory(BlockMenu menu, Block b) {
        if (!BlockStorage.hasBlockInfo(b) || BlockStorage.getLocationInfo(b.getLocation(), KEY_ENABLED) == null || BlockStorage.getLocationInfo(b.getLocation(), KEY_ENABLED).equals(String.valueOf(false))) {
            menu.replaceExistingItem(22, new CustomItem(Material.GUNPOWDER, "&7Enabled: &4\u2718", "", "&e> Click to enable this Machine"));
            menu.addMenuClickHandler(22, (p, slot, item, action) -> {
                BlockStorage.addBlockInfo(b, KEY_ENABLED, String.valueOf(true));
                this.updateBlockInventory(menu, b);
                return false;
            });
        } else {
            menu.replaceExistingItem(22, new CustomItem(Material.REDSTONE, "&7Enabled: &2\u2714", "", "&e> Click to disable this Machine"));
            menu.addMenuClickHandler(22, (p, slot, item, action) -> {
                BlockStorage.addBlockInfo(b, KEY_ENABLED, String.valueOf(false));
                this.updateBlockInventory(menu, b);
                return false;
            });
        }
        double offset = !BlockStorage.hasBlockInfo(b) || BlockStorage.getLocationInfo(b.getLocation(), KEY_OFFSET) == null ? 3.0 : Double.valueOf(BlockStorage.getLocationInfo(b.getLocation(), KEY_OFFSET));
        menu.replaceExistingItem(31, new CustomItem(Material.PISTON, "&7Offset: &3" + offset + " Block(s)", "", "&fLeft Click: &7+0.1", "&fRight Click: &7-0.1"));
        menu.addMenuClickHandler(31, (p, slot, item, action) -> {
            double offsetv = DoubleHandler.fixDouble(Double.valueOf(BlockStorage.getLocationInfo(b.getLocation(), KEY_OFFSET)) + (double)(action.isRightClicked() ? -0.1f : 0.1f));
            BlockStorage.addBlockInfo(b, KEY_OFFSET, String.valueOf(offsetv));
            this.updateBlockInventory(menu, b);
            return false;
        });
    }

    @Override
    public BlockTicker getItemHandler() {
        return new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                if ("false".equals(BlockStorage.getLocationInfo(b.getLocation(), AbstractEntityAssembler.KEY_ENABLED))) {
                    return;
                }
                if (AbstractEntityAssembler.this.lifetime % 60 == 0 && AbstractEntityAssembler.this.getCharge(b.getLocation(), data) >= AbstractEntityAssembler.this.getEnergyConsumption()) {
                    BlockMenu menu = BlockStorage.getInventory(b);
                    boolean hasBody = AbstractEntityAssembler.this.findResource(menu, AbstractEntityAssembler.this.getBody(), AbstractEntityAssembler.this.bodySlots);
                    boolean hasHead = AbstractEntityAssembler.this.findResource(menu, AbstractEntityAssembler.this.getHead(), AbstractEntityAssembler.this.headSlots);
                    if (hasBody && hasHead) {
                        AbstractEntityAssembler.this.consumeResources(menu);
                        AbstractEntityAssembler.this.removeCharge(b.getLocation(), AbstractEntityAssembler.this.getEnergyConsumption());
                        double offset = Double.parseDouble(BlockStorage.getLocationInfo(b.getLocation(), AbstractEntityAssembler.KEY_OFFSET));
                        SlimefunPlugin.runSync(() -> {
                            Location loc = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)b.getY() + offset, (double)b.getZ() + 0.5);
                            AbstractEntityAssembler.this.spawnEntity(loc);
                            b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)AbstractEntityAssembler.this.getHead().getType());
                        });
                    }
                }
            }

            @Override
            public void uniqueTick() {
                AbstractEntityAssembler.this.lifetime++;
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }
        };
    }

    private boolean findResource(BlockMenu menu, ItemStack item, int[] slots) {
        int found = 0;
        for (int slot : slots) {
            if (!SlimefunUtils.isItemSimilar(menu.getItemInSlot(slot), item, true, false) || (found += menu.getItemInSlot(slot).getAmount()) < item.getAmount()) continue;
            return true;
        }
        return false;
    }

    private void consumeResources(BlockMenu inv) {
        int amount;
        int bodyCount = this.getBody().getAmount();
        int headCount = this.getHead().getAmount();
        for (int slot : this.bodySlots) {
            if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), this.getBody(), true, false)) continue;
            amount = inv.getItemInSlot(slot).getAmount();
            if (amount >= bodyCount) {
                inv.consumeItem(slot, bodyCount);
                break;
            }
            bodyCount -= amount;
            inv.replaceExistingItem(slot, null);
        }
        for (int slot : this.headSlots) {
            if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), this.getHead(), true, false)) continue;
            amount = inv.getItemInSlot(slot).getAmount();
            if (amount >= headCount) {
                inv.consumeItem(slot, headCount);
                break;
            }
            headCount -= amount;
            inv.replaceExistingItem(slot, null);
        }
    }

    protected void constructMenu(BlockMenuPreset preset) {
        preset.addItem(1, new CustomItem(this.getHead(), "&7Head Slot", "", "&fThis Slot accepts the head type"), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(7, new CustomItem(this.getBody(), "&7Body Slot", "", "&fThis Slot accepts the body type"), ChestMenuUtils.getEmptyClickHandler());
        preset.addItem(13, new CustomItem(Material.CLOCK, "&7Cooldown: &b30 Seconds", "", "&fThis Machine takes up to half a Minute to operate", "&fso give it some Time!"), ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public abstract int getEnergyConsumption();

    public abstract ItemStack getHead();

    public abstract ItemStack getBody();

    public abstract Material getHeadBorder();

    public abstract Material getBodyBorder();

    public abstract T spawnEntity(Location var1);
}

