/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonNode;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONArray;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.Slimefun;

class ContributionsConnector
extends GitHubConnector {
    private static final List<String> blacklist = Arrays.asList("invalid-email-address", "renovate-bot", "TheBusyBot", "ImgBotApp", "imgbot", "imgbot[bot]", "github-actions[bot]", "gitlocalize-app", "gitlocalize-app[bot]", "mt-gitlocalize");
    private static final Map<String, String> aliases = new HashMap<String, String>();
    private final String prefix;
    private final String role;
    private final int page;
    private boolean finished = false;

    @ParametersAreNonnullByDefault
    ContributionsConnector(GitHubService github, String prefix, int page, String repository, String role) {
        super(github, repository);
        this.prefix = prefix;
        this.page = page;
        this.role = role;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    @Override
    public void onSuccess(@Nonnull JsonNode response) {
        this.finished = true;
        if (response.isArray()) {
            this.computeContributors(response.getArray());
        } else {
            Slimefun.getLogger().log(Level.WARNING, "Received an unusual answer from GitHub, possibly a timeout? ({0})", response);
        }
    }

    @Override
    public void onFailure() {
        this.finished = true;
    }

    @Override
    public String getFileName() {
        return this.prefix + "_contributors";
    }

    @Override
    public String getEndpoint() {
        return "/contributors";
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("per_page", 100);
        parameters.put("page", this.page);
        return parameters;
    }

    private void computeContributors(@Nonnull JSONArray array) {
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.getJSONObject(i);
            String name = object.getString("login");
            int commits = object.getInt("contributions");
            String profile = object.getString("html_url");
            if (blacklist.contains(name)) continue;
            String username = aliases.getOrDefault(name, name);
            this.github.addContributor(username, profile, this.role, commits);
        }
    }

    static {
        aliases.put("WalshyDev", "HumanRightsAct");
        aliases.put("J3fftw1", "_lagpc_");
        aliases.put("ajan-12", "ajan_12");
        aliases.put("mrcoffee1026", "mr_coffee1026");
        aliases.put("Cyber-MC", "CyberPatriot");
        aliases.put("BurningBrimstone", "Bluedevil74");
        aliases.put("bverhoeven", "soczol");
        aliases.put("ramdon-person", "ramdon_person");
        aliases.put("NCBPFluffyBear", "FluffyBear_");
    }
}

