/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.protection;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionLogger;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.loggers.CoreProtectLogger;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.loggers.LogBlockLogger;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.ASkyBlockProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.BentoBoxProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.BlockLockerProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.ChestProtectProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.FactionsUUIDProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.GriefPreventionProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.LWCProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.LandsProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.LocketteProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.PlotSquared4ProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.PlotSquared5ProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.PreciousStonesProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.RedProtectProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.TownyProtectionModule;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.modules.WorldGuardProtectionModule;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public final class ProtectionManager {
    private final Set<ProtectionModule> protectionModules = new HashSet<ProtectionModule>();
    private final Set<ProtectionLogger> protectionLoggers = new HashSet<ProtectionLogger>();
    private final Logger logger;

    public ProtectionManager(@NonNull Server server) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        this.logger = this.getLogger(server);
        this.logger.log(Level.INFO, "Loading Protection Modules...");
        this.logger.log(Level.INFO, "This may happen more than once.");
        this.registerModule(server, "WorldGuard", plugin -> new WorldGuardProtectionModule((Plugin)plugin));
        this.registerModule(server, "Towny", plugin -> new TownyProtectionModule((Plugin)plugin));
        this.registerModule(server, "GriefPrevention", plugin -> new GriefPreventionProtectionModule((Plugin)plugin));
        this.registerModule(server, "ASkyBlock", plugin -> new ASkyBlockProtectionModule((Plugin)plugin));
        this.registerModule(server, "LWC", plugin -> new LWCProtectionModule((Plugin)plugin));
        this.registerModule(server, "PreciousStones", plugin -> new PreciousStonesProtectionModule((Plugin)plugin));
        this.registerModule(server, "Lockette", plugin -> new LocketteProtectionModule((Plugin)plugin));
        this.registerModule(server, "RedProtect", plugin -> new RedProtectProtectionModule((Plugin)plugin));
        this.registerModule(server, "BentoBox", plugin -> new BentoBoxProtectionModule((Plugin)plugin));
        this.registerModule(server, "BlockLocker", plugin -> new BlockLockerProtectionModule((Plugin)plugin));
        this.registerModule(server, "Lands", plugin -> new LandsProtectionModule((Plugin)plugin));
        this.registerModule(server, "ChestProtect", plugin -> new ChestProtectProtectionModule((Plugin)plugin));
        this.registerModule(server, "Factions", plugin -> new FactionsUUIDProtectionModule((Plugin)plugin));
        if (server.getPluginManager().isPluginEnabled("PlotSquared")) {
            Plugin plotSquared = server.getPluginManager().getPlugin("PlotSquared");
            if (plotSquared.getDescription().getVersion().startsWith("4.")) {
                this.registerModule(plotSquared, plugin -> new PlotSquared4ProtectionModule((Plugin)plugin));
            } else {
                this.registerModule(plotSquared, plugin -> new PlotSquared5ProtectionModule((Plugin)plugin));
            }
        }
        if (server.getPluginManager().isPluginEnabled("CoreProtect")) {
            this.registerLogger(new CoreProtectLogger());
        }
        if (server.getPluginManager().isPluginEnabled("LogBlock")) {
            this.registerLogger(new LogBlockLogger());
        }
        if (server.getPluginManager().isPluginEnabled("ProtectionStones")) {
            this.loadModuleMSG("ProtectionStones");
        }
        if (server.getPluginManager().isPluginEnabled("uSkyblock")) {
            this.loadModuleMSG("uSkyblock");
        }
    }

    private Logger getLogger(Server server) {
        Logger customLogger = new Logger("CS-CoreLib2", null){

            @Override
            public void log(@NonNull LogRecord logRecord) {
                if (logRecord == null) {
                    throw new NullPointerException("logRecord is marked non-null but is null");
                }
                logRecord.setMessage(logRecord.getMessage());
                super.log(logRecord);
            }
        };
        customLogger.setParent(server.getLogger());
        customLogger.setLevel(Level.ALL);
        return customLogger;
    }

    public void registerLogger(@NonNull String name, @NonNull ProtectionLogger module) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        this.protectionLoggers.add(module);
        this.loadModuleMSG(name);
    }

    public void registerModule(@NonNull Server server, @NonNull String pluginName, @NonNull Function<Plugin, ProtectionModule> constructor) {
        if (server == null) {
            throw new NullPointerException("server is marked non-null but is null");
        }
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        Plugin plugin = server.getPluginManager().getPlugin(pluginName);
        if (plugin != null && plugin.isEnabled()) {
            this.registerModule(plugin, constructor);
        }
    }

    private void registerModule(@NonNull Plugin plugin, @NonNull Function<Plugin, ProtectionModule> constructor) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        try {
            ProtectionModule module = constructor.apply(plugin);
            module.load();
            this.protectionModules.add(module);
            this.loadModuleMSG(module.getName() + " v" + module.getVersion());
        }
        catch (Throwable x) {
            this.logger.log(Level.SEVERE, x, () -> "An Error occured while registering the Protection Module: \"" + plugin.getName() + "\" v" + plugin.getDescription().getVersion());
        }
    }

    public void registerLogger(@NonNull ProtectionLogger module) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        try {
            module.load();
            this.registerLogger(module.getName(), module);
        }
        catch (Throwable x) {
            this.logger.log(Level.SEVERE, x, () -> "An Error occured while registering the Protection Module: \"" + module.getName() + "\"");
        }
    }

    private void loadModuleMSG(String module) {
        this.logger.log(Level.INFO, "Loaded Protection Module \"{0}\"", module);
    }

    public boolean hasPermission(@NonNull OfflinePlayer p, @NonNull Block b, @NonNull ProtectableAction action) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return this.hasPermission(p, b.getLocation(), action);
    }

    public boolean hasPermission(@NonNull OfflinePlayer p, @NonNull Location l, @NonNull ProtectableAction action) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (l == null) {
            throw new NullPointerException("l is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        for (ProtectionModule module : this.protectionModules) {
            try {
                if (module.hasPermission(p, l, action)) continue;
                return false;
            }
            catch (Exception x) {
                this.logger.log(Level.SEVERE, x, () -> "An Error occured while querying the Protection Module: \"" + module.getName() + " v" + module.getVersion() + "\"");
                return true;
            }
        }
        return true;
    }

    public void logAction(@NonNull OfflinePlayer p, @NonNull Block b, @NonNull ProtectableAction action) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        for (ProtectionLogger module : this.protectionLoggers) {
            try {
                module.logAction(p, b, action);
            }
            catch (Exception x) {
                this.logger.log(Level.SEVERE, x, () -> "An Error occured while logging for the Protection Module: \"" + module.getName() + "\"");
            }
        }
    }
}

