/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.FarmerShoes;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.StomperBoots;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class SlimefunBootsListener
implements Listener {
    public SlimefunBootsListener(@Nonnull SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && e.getCause() == EntityDamageEvent.DamageCause.FALL) {
            this.onFallDamage(e);
        }
    }

    @EventHandler
    public void onEnderPearlDamage(EntityDamageByEntityEvent e) {
        Player p;
        SlimefunItem boots;
        if (e.getDamager() instanceof EnderPearl && e.getEntity() instanceof Player && (boots = SlimefunItem.getByItem((p = (Player)e.getEntity()).getInventory().getBoots())) != null && boots.getId().equals("ENDER_BOOTS") && Slimefun.hasUnlocked(p, boots, true)) {
            e.setCancelled(true);
        }
    }

    private void onFallDamage(@Nonnull EntityDamageEvent e) {
        Player p = (Player)e.getEntity();
        SlimefunItem boots = SlimefunItem.getByItem(p.getInventory().getBoots());
        if (boots != null) {
            if (!Slimefun.hasUnlocked(p, boots, true)) {
                return;
            }
            if (boots instanceof StomperBoots) {
                e.setCancelled(true);
                ((StomperBoots)boots).stomp(e);
            } else if (boots.getId().equals("SLIME_BOOTS") || boots.getId().equals("SLIME_STEEL_BOOTS")) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onTrample(PlayerInteractEvent e) {
        Player p;
        SlimefunItem boots;
        Block b;
        if (e.getAction() == Action.PHYSICAL && (b = e.getClickedBlock()) != null && b.getType() == Material.FARMLAND && (boots = SlimefunItem.getByItem((p = e.getPlayer()).getInventory().getBoots())) instanceof FarmerShoes && Slimefun.hasUnlocked(p, boots, true)) {
            e.setCancelled(true);
        }
    }
}

