/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.api.items.HashedArmorpiece;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectionType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.SlimefunArmorPiece;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.SolarHelmet;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ArmorTask
implements Runnable {
    private final Set<PotionEffect> radiationEffects;
    private final boolean radioactiveFire;

    public ArmorTask(boolean radioactiveFire) {
        this.radioactiveFire = radioactiveFire;
        HashSet<PotionEffect> effects = new HashSet<PotionEffect>();
        effects.add(new PotionEffect(PotionEffectType.WITHER, 400, 2));
        effects.add(new PotionEffect(PotionEffectType.BLINDNESS, 400, 3));
        effects.add(new PotionEffect(PotionEffectType.CONFUSION, 400, 3));
        effects.add(new PotionEffect(PotionEffectType.WEAKNESS, 400, 2));
        effects.add(new PotionEffect(PotionEffectType.SLOW, 400, 1));
        effects.add(new PotionEffect(PotionEffectType.SLOW_DIGGING, 400, 1));
        this.radiationEffects = Collections.unmodifiableSet(effects);
    }

    @Nonnull
    public Set<PotionEffect> getRadiationEffects() {
        return this.radiationEffects;
    }

    @Override
    public void run() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.isValid() || p.isDead()) continue;
            PlayerProfile.get((OfflinePlayer)p, profile -> {
                ItemStack[] armor = p.getInventory().getArmorContents();
                HashedArmorpiece[] cachedArmor = profile.getArmor();
                this.handleSlimefunArmor(p, armor, cachedArmor);
                if (this.hasSunlight(p)) {
                    this.checkForSolarHelmet(p);
                }
                this.checkForRadiation(p, (PlayerProfile)profile);
            });
        }
    }

    @ParametersAreNonnullByDefault
    private void handleSlimefunArmor(Player p, ItemStack[] armor, HashedArmorpiece[] cachedArmor) {
        for (int slot = 0; slot < 4; ++slot) {
            HashedArmorpiece armorpiece = cachedArmor[slot];
            ItemStack item = armor[slot];
            if (armorpiece.hasDiverged(item)) {
                SlimefunItem sfItem = SlimefunItem.getByItem(item);
                if (!(sfItem instanceof SlimefunArmorPiece)) {
                    sfItem = null;
                }
                armorpiece.update(item, sfItem);
            }
            if (item == null || !armorpiece.getItem().isPresent()) continue;
            SlimefunPlugin.runSync(() -> {
                SlimefunArmorPiece slimefunArmor = armorpiece.getItem().get();
                if (Slimefun.hasUnlocked(p, slimefunArmor, true)) {
                    for (PotionEffect effect : slimefunArmor.getPotionEffects()) {
                        p.removePotionEffect(effect.getType());
                        p.addPotionEffect(effect);
                    }
                }
            });
        }
    }

    private void checkForSolarHelmet(@Nonnull Player p) {
        ItemStack helmet = p.getInventory().getHelmet();
        if (SlimefunPlugin.getRegistry().isBackwardsCompatible() && !SlimefunUtils.isItemSimilar(helmet, SlimefunItems.SOLAR_HELMET, true, false)) {
            return;
        }
        SlimefunItem item = SlimefunItem.getByItem(helmet);
        if (item instanceof SolarHelmet && Slimefun.hasUnlocked(p, item, true)) {
            ((SolarHelmet)item).rechargeItems(p);
        }
    }

    private boolean hasSunlight(@Nonnull Player p) {
        World world = p.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return false;
        }
        return (world.getTime() < 12300L || world.getTime() > 23850L) && p.getEyeLocation().getBlock().getLightFromSky() == 15;
    }

    private void checkForRadiation(@Nonnull Player p, @Nonnull PlayerProfile profile) {
        block1: {
            ItemStack item;
            if (profile.hasFullProtectionAgainst(ProtectionType.RADIATION)) break block1;
            ListIterator listIterator = p.getInventory().iterator();
            while (listIterator.hasNext() && !this.checkAndApplyRadiation(p, item = (ItemStack)listIterator.next())) {
            }
        }
    }

    private boolean checkAndApplyRadiation(@Nonnull Player p, @Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        Set<SlimefunItem> radioactiveItems = SlimefunPlugin.getRegistry().getRadioactiveItems();
        ItemStack subject = item;
        if (!(item instanceof SlimefunItemStack) && radioactiveItems.size() > 1) {
            subject = new ItemStackWrapper(item);
        }
        for (SlimefunItem radioactiveItem : radioactiveItems) {
            if (!radioactiveItem.isItem(subject) || !Slimefun.isEnabled(p, radioactiveItem, true)) continue;
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.radiation");
            SlimefunPlugin.runSync(() -> {
                p.addPotionEffects(this.radiationEffects);
                if (this.radioactiveFire) {
                    p.setFireTicks(400);
                }
            });
            return true;
        }
        return false;
    }
}

