/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.tools.GrapplingHook;
import io.github.thebusybiscuit.slimefun4.implementation.listeners.GrapplingHookEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GrapplingHookListener
implements Listener {
    private GrapplingHook grapplingHook;
    private final Map<UUID, GrapplingHookEntity> activeHooks = new HashMap<UUID, GrapplingHookEntity>();
    private final Set<UUID> invulnerability = new HashSet<UUID>();

    public void register(@Nonnull SlimefunPlugin plugin, @Nonnull GrapplingHook grapplingHook) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.grapplingHook = grapplingHook;
    }

    private boolean isEnabled() {
        return this.grapplingHook != null && !this.grapplingHook.isDisabled();
    }

    @EventHandler
    public void onArrowHitEntity(EntityDamageByEntityEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getDamager() instanceof Arrow) {
            this.handleGrapplingHook((Arrow)e.getDamager());
        }
    }

    @EventHandler
    public void onArrowHitSurface(ProjectileHitEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        SlimefunPlugin.runSync(() -> {
            if (e.getEntity() instanceof Arrow) {
                this.handleGrapplingHook((Arrow)e.getEntity());
            }
        }, 2L);
    }

    @EventHandler
    public void onArrowHitHanging(HangingBreakByEntityEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getRemover() instanceof Arrow) {
            this.handleGrapplingHook((Arrow)e.getRemover());
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        UUID uuid = e.getPlayer().getUniqueId();
        this.activeHooks.remove(uuid);
        this.invulnerability.remove(uuid);
    }

    @EventHandler
    public void onLeave(PlayerKickEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        UUID uuid = e.getPlayer().getUniqueId();
        this.activeHooks.remove(uuid);
        this.invulnerability.remove(uuid);
    }

    @EventHandler
    public void onFallDamage(EntityDamageEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getEntity() instanceof Player && e.getCause() == EntityDamageEvent.DamageCause.FALL && this.invulnerability.remove(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPortalEnter(EntityPortalEnterEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (e.getEntity() instanceof Arrow) {
            this.handleGrapplingHook((Arrow)e.getEntity());
        }
    }

    @EventHandler
    public void onLeash(PlayerLeashEntityEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack item = p.getInventory().getItemInMainHand();
        SlimefunItem slimeItem = SlimefunItem.getByItem(item);
        if (slimeItem instanceof GrapplingHook) {
            e.setCancelled(true);
        }
    }

    private void handleGrapplingHook(@Nullable Arrow arrow) {
        Player p;
        GrapplingHookEntity hook;
        if (arrow != null && arrow.isValid() && arrow.getShooter() instanceof Player && (hook = this.activeHooks.get((p = (Player)arrow.getShooter()).getUniqueId())) != null) {
            Location target = arrow.getLocation();
            hook.drop(target);
            Vector velocity = new Vector(0.0, 0.2, 0.0);
            if (p.getLocation().distance(target) < 3.0) {
                if (target.getY() <= p.getLocation().getY()) {
                    velocity = target.toVector().subtract(p.getLocation().toVector());
                }
            } else {
                double d;
                Location l = p.getLocation();
                l.setY(l.getY() + 0.5);
                p.teleport(l);
                double g = -0.08;
                double t = d = target.distance(l);
                double vX = (1.0 + 0.08 * t) * (target.getX() - l.getX()) / t;
                double vY = (1.0 + 0.04 * t) * (target.getY() - l.getY()) / t - 0.5 * g * t;
                double vZ = (1.0 + 0.08 * t) * (target.getZ() - l.getZ()) / t;
                velocity = p.getVelocity();
                velocity.setX(vX);
                velocity.setY(vY);
                velocity.setZ(vZ);
            }
            p.setVelocity(velocity);
            hook.remove();
            SlimefunPlugin.runSync(() -> this.activeHooks.remove(p.getUniqueId()), 20L);
        }
    }

    public boolean isGrappling(@Nonnull UUID uuid) {
        return this.activeHooks.containsKey(uuid);
    }

    @ParametersAreNonnullByDefault
    public void addGrapplingHook(Player p, Arrow arrow, Bat bat, boolean dropItem, long despawnTicks, boolean wasConsumed) {
        GrapplingHookEntity hook = new GrapplingHookEntity(p, arrow, (Entity)bat, dropItem, wasConsumed);
        UUID uuid = p.getUniqueId();
        this.activeHooks.put(uuid, hook);
        SlimefunPlugin.runSync(() -> {
            GrapplingHookEntity entity = this.activeHooks.get(uuid);
            if (entity != null) {
                SlimefunPlugin.getBowListener().getProjectileData().remove(uuid);
                entity.remove();
                SlimefunPlugin.runSync(() -> {
                    this.activeHooks.remove(uuid);
                    this.invulnerability.remove(uuid);
                }, 20L);
            }
        }, despawnTicks);
    }
}

