/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items.settings;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public class EnumSetting<T extends Enum<T>>
extends ItemSetting<String> {
    private final Class<T> enumClass;

    @ParametersAreNonnullByDefault
    public EnumSetting(String key, Class<T> enumClass, T defaultValue) {
        super(key, ((Enum)defaultValue).name());
        this.enumClass = enumClass;
    }

    @Override
    @Nonnull
    protected String getErrorMessage() {
        String values = Arrays.stream(this.getAllowedValues()).map(Enum::name).collect(Collectors.joining(", "));
        return "The following values are valid: " + values;
    }

    public T[] getAllowedValues() {
        return (Enum[])this.enumClass.getEnumConstants();
    }

    public T getAsEnumConstant() {
        return Enum.valueOf(this.enumClass, (String)this.getValue());
    }

    @Override
    public boolean validateInput(String input) {
        if (!super.validateInput(input)) {
            return false;
        }
        for (Enum value : this.getAllowedValues()) {
            if (!value.name().equals(input)) continue;
            return true;
        }
        return false;
    }
}

