/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.protection.modules;

import java.util.Optional;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectionModule;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.managers.IslandWorldManager;
import world.bentobox.bentobox.managers.IslandsManager;

public class BentoBoxProtectionModule
implements ProtectionModule {
    private IslandsManager manager;
    private IslandWorldManager iwm;
    private final Plugin plugin;

    public BentoBoxProtectionModule(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.manager = BentoBox.getInstance().getIslands();
        this.iwm = BentoBox.getInstance().getIWM();
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, ProtectableAction action) {
        Optional island = this.manager.getIslandAt(l);
        Flag flag = this.convert(action, l.getWorld());
        return !this.iwm.inWorld(l) || island.map(value -> value.isAllowed(User.getInstance((OfflinePlayer)p), flag)).orElse(flag.isSetForWorld(l.getWorld())) != false;
    }

    private Flag convert(ProtectableAction action, World world) {
        switch (action) {
            case ACCESS_INVENTORIES: {
                return Flags.CONTAINER;
            }
            case PVP: {
                if (world != null) {
                    if (world.getEnvironment() == World.Environment.NETHER) {
                        return Flags.PVP_NETHER;
                    }
                    if (world.getEnvironment() == World.Environment.THE_END) {
                        return Flags.PVP_END;
                    }
                }
                return Flags.PVP_OVERWORLD;
            }
            case BREAK_BLOCK: {
                return Flags.BREAK_BLOCKS;
            }
        }
        return Flags.PLACE_BLOCKS;
    }
}

