/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class SoulboundListener
implements Listener {
    private final Map<UUID, Map<Integer, ItemStack>> soulbound = new HashMap<UUID, Map<Integer, ItemStack>>();

    public SoulboundListener(@Nonnull SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onDamage(PlayerDeathEvent e) {
        ItemStack item;
        Player p = e.getEntity();
        for (int slot = 0; slot < p.getInventory().getSize(); ++slot) {
            item = p.getInventory().getItem(slot);
            if (!SlimefunUtils.isSoulbound(item)) continue;
            this.storeItem(p.getUniqueId(), slot, item);
        }
        Iterator drops = e.getDrops().iterator();
        while (drops.hasNext()) {
            item = (ItemStack)drops.next();
            if (!SlimefunUtils.isSoulbound(item)) continue;
            drops.remove();
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        this.retrieveItems(e.getPlayer());
    }

    @ParametersAreNonnullByDefault
    private void storeItem(UUID uuid, int slot, ItemStack item) {
        Map items = this.soulbound.computeIfAbsent(uuid, uid -> new HashMap());
        items.put(slot, item);
    }

    private void retrieveItems(@Nonnull Player p) {
        Map<Integer, ItemStack> items = this.soulbound.remove(p.getUniqueId());
        if (items != null) {
            for (Map.Entry<Integer, ItemStack> entry : items.entrySet()) {
                p.getInventory().setItem(entry.getKey().intValue(), entry.getValue());
            }
        }
    }
}

