/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.core.attributes.RandomMobDrop;
import io.github.thebusybiscuit.slimefun4.core.handlers.EntityKillHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.misc.BasicCircuitBoard;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MobDropListener
implements Listener {
    public MobDropListener(@Nonnull SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onEntityKill(EntityDeathEvent e) {
        if (e.getEntity().getKiller() != null) {
            SlimefunItem sfItem;
            Player p = e.getEntity().getKiller();
            ItemStack item = p.getInventory().getItemInMainHand();
            Set<ItemStack> customDrops = SlimefunPlugin.getRegistry().getMobDrops().get(e.getEntityType());
            if (customDrops != null && !customDrops.isEmpty()) {
                for (ItemStack drop : customDrops) {
                    if (!this.canDrop(p, drop)) continue;
                    e.getDrops().add(drop.clone());
                }
            }
            if (item.getType() != Material.AIR && (sfItem = SlimefunItem.getByItem(item)) != null && Slimefun.hasUnlocked(p, sfItem, true)) {
                sfItem.callItemHandler(EntityKillHandler.class, handler -> handler.onKill(e, (Entity)e.getEntity(), p, item));
            }
        }
    }

    private boolean canDrop(@Nonnull Player p, @Nonnull ItemStack item) {
        SlimefunItem sfi = SlimefunItem.getByItem(item);
        if (sfi == null) {
            return true;
        }
        if (Slimefun.hasUnlocked(p, sfi, true)) {
            if (sfi instanceof RandomMobDrop) {
                int random = ThreadLocalRandom.current().nextInt(100);
                if (((RandomMobDrop)((Object)sfi)).getMobDropChance() <= random) {
                    return false;
                }
            }
            if (sfi instanceof BasicCircuitBoard) {
                return ((BasicCircuitBoard)sfi).isDroppedFromGolems();
            }
            return true;
        }
        return false;
    }
}

