/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.generators;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class SolarGenerator
extends SlimefunItem
implements EnergyNetProvider {
    private final int dayEnergy;
    private final int nightEnergy;

    public SolarGenerator(Category category, int dayEnergy, int nightEnergy, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.dayEnergy = dayEnergy;
        this.nightEnergy = nightEnergy;
    }

    public int getDayEnergy() {
        return this.dayEnergy;
    }

    public int getNightEnergy() {
        return this.nightEnergy;
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public int getGeneratedOutput(Location l, Config data) {
        World world = l.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return 0;
        }
        boolean isDaytime = this.isDaytime(world);
        if (!isDaytime && this.getNightEnergy() < 1) {
            return 0;
        }
        if (!world.isChunkLoaded(l.getBlockX() >> 4, l.getBlockZ() >> 4) || l.getBlock().getLightFromSky() < 15) {
            return 0;
        }
        return isDaytime ? this.getDayEnergy() : this.getNightEnergy();
    }

    private boolean isDaytime(World world) {
        long time = world.getTime();
        return !world.hasStorm() && !world.isThundering() && (time < 12300L || time > 23850L);
    }

    @Override
    public void preRegister() {
        super.preRegister();
        BlockUseHandler handler = PlayerRightClickEvent::cancel;
        this.addItemHandler(handler);
    }
}

