/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler;

import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceRating;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceSummary;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.ProfiledBlock;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.apache.commons.lang.Validate;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;

public class SlimefunProfiler {
    private static final int MAX_TICK_DURATION = 100;
    private final ExecutorService executor = Executors.newFixedThreadPool(5);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicInteger queued = new AtomicInteger(0);
    private long totalElapsedTime;
    private final Map<ProfiledBlock, Long> timings = new ConcurrentHashMap<ProfiledBlock, Long>();
    private final Queue<CommandSender> requests = new ConcurrentLinkedQueue<CommandSender>();

    public void start() {
        this.running.set(true);
        this.queued.set(0);
        this.timings.clear();
    }

    public long newEntry() {
        if (!this.running.get()) {
            return 0L;
        }
        this.queued.incrementAndGet();
        return System.nanoTime();
    }

    public void scheduleEntries(int amount) {
        if (this.running.get()) {
            this.queued.getAndAdd(amount);
        }
    }

    public long closeEntry(@Nonnull Location l, @Nonnull SlimefunItem item, long timestamp) {
        Validate.notNull((Object)l, (String)"Location must not be null!");
        Validate.notNull((Object)item, (String)"You need to specify a SlimefunItem!");
        if (timestamp == 0L) {
            return 0L;
        }
        long elapsedTime = System.nanoTime() - timestamp;
        this.executor.execute(() -> {
            ProfiledBlock block = new ProfiledBlock(l, item);
            this.timings.merge(block, elapsedTime, Long::sum);
            this.queued.decrementAndGet();
        });
        return elapsedTime;
    }

    public void stop() {
        this.running.set(false);
        if (SlimefunPlugin.instance() == null || !SlimefunPlugin.instance().isEnabled()) {
            return;
        }
        this.executor.execute(this::finishReport);
    }

    private void finishReport() {
        int iterations = 4000;
        while (!this.running.get() && this.queued.get() > 0) {
            try {
                Thread.sleep(1L);
                if (--iterations > 0) continue;
                Iterator iterator = this.requests.iterator();
                while (iterator.hasNext()) {
                    ((CommandSender)iterator.next()).sendMessage("Your timings report has timed out, we were still waiting for " + this.queued.get() + " samples to be collected :/");
                    iterator.remove();
                }
                return;
            }
            catch (InterruptedException e) {
                Slimefun.getLogger().log(Level.SEVERE, "A Profiler Thread was interrupted", e);
                Thread.currentThread().interrupt();
            }
        }
        if (this.running.get() && this.queued.get() > 0) {
            return;
        }
        this.totalElapsedTime = this.timings.values().stream().mapToLong(Long::longValue).sum();
        if (!this.requests.isEmpty()) {
            PerformanceSummary summary = new PerformanceSummary(this, this.totalElapsedTime, this.timings.size());
            Iterator iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                summary.send((CommandSender)iterator.next());
                iterator.remove();
            }
        }
    }

    public void requestSummary(@Nonnull CommandSender sender) {
        Validate.notNull((Object)sender, (String)"Cannot request a summary for null");
        this.requests.add(sender);
    }

    @Nonnull
    protected Map<String, Long> getByItem() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Map.Entry<ProfiledBlock, Long> entry : this.timings.entrySet()) {
            map.merge(entry.getKey().getId(), entry.getValue(), Long::sum);
        }
        return map;
    }

    @Nonnull
    protected Map<String, Long> getByPlugin() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Map.Entry<ProfiledBlock, Long> entry : this.timings.entrySet()) {
            map.merge(entry.getKey().getAddon().getName(), entry.getValue(), Long::sum);
        }
        return map;
    }

    @Nonnull
    protected Map<String, Long> getByChunk() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (Map.Entry<ProfiledBlock, Long> entry : this.timings.entrySet()) {
            String world = entry.getKey().getPosition().getWorld().getName();
            int x = entry.getKey().getPosition().getChunkX();
            int z = entry.getKey().getPosition().getChunkZ();
            map.merge(world + " (" + x + ',' + z + ')', entry.getValue(), Long::sum);
        }
        return map;
    }

    protected int getBlocksInChunk(@Nonnull String chunk) {
        Validate.notNull((Object)chunk, (String)"The chunk cannot be null!");
        int blocks = 0;
        for (ProfiledBlock block : this.timings.keySet()) {
            String world = block.getPosition().getWorld().getName();
            int x = block.getPosition().getChunkX();
            int z = block.getPosition().getChunkZ();
            if (!chunk.equals(world + " (" + x + ',' + z + ')')) continue;
            ++blocks;
        }
        return blocks;
    }

    protected int getBlocksOfId(@Nonnull String id) {
        Validate.notNull((Object)id, (String)"The id cannot be null!");
        int blocks = 0;
        for (ProfiledBlock block : this.timings.keySet()) {
            if (!block.getId().equals(id)) continue;
            ++blocks;
        }
        return blocks;
    }

    protected int getBlocksFromPlugin(@Nonnull String pluginName) {
        Validate.notNull((Object)pluginName, (String)"The Plugin name cannot be null!");
        int blocks = 0;
        for (ProfiledBlock block : this.timings.keySet()) {
            if (!block.getAddon().getName().equals(pluginName)) continue;
            ++blocks;
        }
        return blocks;
    }

    protected float getPercentageOfTick() {
        float millis = (float)this.totalElapsedTime / 1000000.0f;
        float fraction = millis * 100.0f / 100.0f;
        return Math.round(fraction * 100.0f / 100.0f);
    }

    @Nonnull
    public PerformanceRating getPerformance() {
        float percentage = this.getPercentageOfTick();
        for (PerformanceRating rating : PerformanceRating.valuesCache) {
            if (!rating.test(Float.valueOf(percentage))) continue;
            return rating;
        }
        return PerformanceRating.UNKNOWN;
    }

    public String getTime() {
        return NumberUtils.getAsMillis(this.totalElapsedTime);
    }

    public int getTickRate() {
        return SlimefunPlugin.getTickerTask().getTickRate();
    }

    public boolean hasTimings(@Nonnull Block b) {
        Validate.notNull((Object)"Cannot get timings for a null Block");
        return this.timings.containsKey(new ProfiledBlock(b));
    }

    public String getTime(@Nonnull Block b) {
        Validate.notNull((Object)"Cannot get timings for a null Block");
        long time = this.timings.getOrDefault(new ProfiledBlock(b), 0L);
        return NumberUtils.getAsMillis(time);
    }

    public String getTime(@Nonnull Chunk chunk) {
        Validate.notNull((Object)"Cannot get timings for a null Chunk");
        long time = this.getByChunk().getOrDefault(chunk.getWorld().getName() + " (" + chunk.getX() + ',' + chunk.getZ() + ')', 0L);
        return NumberUtils.getAsMillis(time);
    }

    public String getTime(@Nonnull SlimefunItem item) {
        Validate.notNull((Object)"Cannot get timings for a null SlimefunItem");
        long time = this.getByItem().getOrDefault(item.getId(), 0L);
        return NumberUtils.getAsMillis(time);
    }
}

