/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Path {
    private String url;
    private String rawPath;

    Path(String url, String defaultBasePath) {
        if (defaultBasePath != null && url != null && !url.toLowerCase().startsWith("http")) {
            String full;
            this.url = full = defaultBasePath + url;
            this.rawPath = full;
        } else {
            this.url = url;
            this.rawPath = url;
        }
    }

    public Path(String url) {
        this(url, null);
    }

    public void param(Map<String, Object> params) {
        params.forEach((key, value) -> this.param((String)key, String.valueOf(value)));
    }

    public void param(String name, String value) {
        Matcher matcher = Pattern.compile("\\{" + name + "\\}").matcher(this.url);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count == 0) {
            throw new UnirestException("Can't find route parameter name \"" + name + "\"");
        }
        this.url = this.url.replaceAll("\\{" + name + "\\}", this.encodePath(value));
    }

    private String encodePath(String value) {
        if (value == null) {
            return "";
        }
        return Util.encode(value).replaceAll("\\+", "%20");
    }

    public void queryString(String name, Collection<?> value) {
        for (Object cur : value) {
            this.queryString(name, cur);
        }
    }

    public void queryString(String name, Object value) {
        StringBuilder queryString = new StringBuilder();
        if (this.url.contains("?")) {
            queryString.append("&");
        } else {
            queryString.append("?");
        }
        try {
            queryString.append(URLEncoder.encode(name, "UTF-8"));
            if (value != null) {
                queryString.append("=").append(URLEncoder.encode(String.valueOf(value), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new UnirestException(e);
        }
        this.url = this.url + queryString.toString();
    }

    public void queryString(Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                this.queryString(param.getKey(), param.getValue());
            }
        }
    }

    public String toString() {
        return this.url;
    }

    public String rawPath() {
        return this.rawPath;
    }

    public String baseUrl() {
        if (this.url.contains("?")) {
            return this.url.substring(0, this.url.indexOf("?"));
        }
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return Objects.equals(this.url, path.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }
}

