/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import me.mrCookieSlime.Slimefun.cscorelib2.scheduling.TaskQueue;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Composter
extends SimpleSlimefunItem<BlockUseHandler>
implements RecipeDisplayItem {
    private static final BlockFace[] outputFaces = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private final List<ItemStack> recipes = this.getMachineRecipes();

    public Composter(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes;
    }

    private List<ItemStack> getMachineRecipes() {
        LinkedList<ItemStack> items = new LinkedList<ItemStack>();
        for (Material leave : Tag.LEAVES.getValues()) {
            items.add(new ItemStack(leave, 8));
            items.add(new ItemStack(Material.DIRT));
        }
        for (Material sapling : Tag.SAPLINGS.getValues()) {
            items.add(new ItemStack(sapling, 8));
            items.add(new ItemStack(Material.DIRT));
        }
        items.add(new ItemStack(Material.STONE, 4));
        items.add(new ItemStack(Material.NETHERRACK));
        items.add(new ItemStack(Material.SAND, 2));
        items.add(new ItemStack(Material.SOUL_SAND));
        items.add(new ItemStack(Material.WHEAT, 4));
        items.add(new ItemStack(Material.NETHER_WART));
        return items;
    }

    @Override
    public BlockUseHandler getItemHandler() {
        return e -> {
            Optional<Block> block = e.getClickedBlock();
            if (block.isPresent()) {
                e.cancel();
                Player p = e.getPlayer();
                Block b = block.get();
                if (p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES)) {
                    ItemStack input = e.getItem();
                    ItemStack output = this.getOutput(p, input);
                    if (output != null) {
                        TaskQueue tasks = new TaskQueue();
                        tasks.thenRepeatEvery(30, 10, () -> {
                            Material material = input.getType().isBlock() ? input.getType() : Material.HAY_BLOCK;
                            b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)material);
                        });
                        tasks.thenRun(20, () -> {
                            p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f);
                            this.pushItem(b, output.clone());
                        });
                        tasks.execute((Plugin)SlimefunPlugin.instance());
                    } else {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.wrong-item", true);
                    }
                }
            }
        };
    }

    private void pushItem(Block b, ItemStack output) {
        Optional<Inventory> outputChest = this.findOutputChest(b, output);
        if (outputChest.isPresent()) {
            outputChest.get().addItem(new ItemStack[]{output});
        } else {
            Location loc = b.getRelative(BlockFace.UP).getLocation();
            b.getWorld().dropItemNaturally(loc, output);
        }
    }

    private Optional<Inventory> findOutputChest(Block b, ItemStack output) {
        for (BlockFace face : outputFaces) {
            Inventory inv;
            BlockState state;
            String id;
            Block potentialOutput = b.getRelative(face);
            if (potentialOutput.getType() != Material.CHEST || (id = BlockStorage.checkID(potentialOutput)) == null || !id.equals("OUTPUT_CHEST") || !((state = PaperLib.getBlockState(potentialOutput, false).getState()) instanceof Chest) || !InvUtils.fits(inv = ((Chest)state).getInventory(), output, new int[0])) continue;
            return Optional.of(inv);
        }
        return Optional.empty();
    }

    private ItemStack getOutput(Player p, ItemStack input) {
        for (int i = 0; i < this.recipes.size(); i += 2) {
            ItemStack convert = this.recipes.get(i);
            if (convert == null || !SlimefunUtils.isItemSimilar(input, convert, true)) continue;
            ItemStack removing = input.clone();
            removing.setAmount(convert.getAmount());
            p.getInventory().removeItem(new ItemStack[]{removing});
            return this.recipes.get(i + 1);
        }
        return null;
    }
}

