/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.MaterialTagSetting;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockDispenseHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.List;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Dispenser;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BlockPlacer
extends SlimefunItem {
    private final ItemSetting<List<String>> blacklist = new MaterialTagSetting("unplaceable-blocks", SlimefunTag.UNBREAKABLE_MATERIALS);

    public BlockPlacer(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.blacklist);
        this.addItemHandler(this.onPlace(), this.onBlockDispense());
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                Player p = e.getPlayer();
                Block b = e.getBlock();
                BlockStorage.addBlockInfo(b, "owner", p.getUniqueId().toString());
            }
        };
    }

    private BlockDispenseHandler onBlockDispense() {
        return (e, dispenser, facedBlock, machine) -> {
            if (!this.hasPermission(dispenser, facedBlock)) {
                e.setCancelled(true);
                return;
            }
            Material material = e.getItem().getType();
            if (SlimefunTag.SHULKER_BOXES.isTagged(material)) {
                return;
            }
            e.setCancelled(true);
            if (!material.isBlock() || SlimefunTag.BLOCK_PLACER_IGNORED_MATERIALS.isTagged(material)) {
                return;
            }
            if (facedBlock.isEmpty() && !this.isBlacklisted(material)) {
                SlimefunItem item = SlimefunItem.getByItem(e.getItem());
                if (item != null) {
                    if (!(item instanceof NotPlaceable)) {
                        this.placeSlimefunBlock(item, e.getItem(), facedBlock, dispenser);
                    }
                } else {
                    this.placeBlock(e.getItem(), facedBlock, dispenser);
                }
            }
        };
    }

    private boolean hasPermission(Dispenser dispenser, Block target) {
        String owner = BlockStorage.getLocationInfo(dispenser.getLocation(), "owner");
        if (owner == null) {
            return true;
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(owner));
        return SlimefunPlugin.getProtectionManager().hasPermission(player, target, ProtectableAction.PLACE_BLOCK);
    }

    private boolean isBlacklisted(Material type) {
        for (String blockType : this.blacklist.getValue()) {
            if (!type.toString().equals(blockType)) continue;
            return true;
        }
        return false;
    }

    private void placeSlimefunBlock(SlimefunItem sfItem, ItemStack item, Block block, Dispenser dispenser) {
        boolean hasItemHandler;
        BlockPlacerPlaceEvent e = new BlockPlacerPlaceEvent(dispenser.getBlock(), item, block);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (!e.isCancelled() && !(hasItemHandler = sfItem.callItemHandler(BlockPlaceHandler.class, handler -> {
            if (handler.isBlockPlacerAllowed()) {
                block.setType(item.getType());
                block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)item.getType());
                BlockStorage.store(block, sfItem.getId());
                handler.onBlockPlacerPlace(e);
                if (dispenser.getInventory().containsAtLeast(item, 2)) {
                    dispenser.getInventory().removeItem(new ItemStack[]{new CustomItem(item, 1)});
                } else {
                    SlimefunPlugin.runSync(() -> dispenser.getInventory().removeItem(new ItemStack[]{item}), 2L);
                }
            }
        }))) {
            block.setType(item.getType());
            block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)item.getType());
            BlockStorage.store(block, sfItem.getId());
            if (dispenser.getInventory().containsAtLeast(item, 2)) {
                dispenser.getInventory().removeItem(new ItemStack[]{new CustomItem(item, 1)});
            } else {
                SlimefunPlugin.runSync(() -> dispenser.getInventory().removeItem(new ItemStack[]{item}), 2L);
            }
        }
    }

    private void placeBlock(ItemStack item, Block facedBlock, Dispenser dispenser) {
        BlockPlacerPlaceEvent e = new BlockPlacerPlaceEvent(dispenser.getBlock(), item, facedBlock);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (!e.isCancelled()) {
            BlockStateSnapshotResult blockState;
            ItemMeta meta;
            facedBlock.setType(item.getType());
            if (item.hasItemMeta() && (meta = item.getItemMeta()).hasDisplayName() && (blockState = PaperLib.getBlockState(facedBlock, false)).getState() instanceof Nameable) {
                Nameable nameable = (Nameable)blockState.getState();
                nameable.setCustomName(meta.getDisplayName());
                if (blockState.isSnapshot()) {
                    blockState.getState().update(true, false);
                }
            }
            facedBlock.getWorld().playEffect(facedBlock.getLocation(), Effect.STEP_SOUND, (Object)item.getType());
            if (dispenser.getInventory().containsAtLeast(item, 2)) {
                dispenser.getInventory().removeItem(new ItemStack[]{new CustomItem(item, 1)});
            } else {
                SlimefunPlugin.runSync(() -> dispenser.getInventory().removeItem(new ItemStack[]{item}), 2L);
            }
        }
    }
}

