/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.plugins;

import com.gmail.nossr50.events.fake.FakeBlockBreakEvent;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.ClearLagIntegration;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.EmeraldEnchantsCategory;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.McMMOIntegration;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.PlaceholderAPIIntegration;
import io.github.thebusybiscuit.slimefun4.core.services.plugins.WorldEditIntegration;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ThirdPartyPluginService {
    private final SlimefunPlugin plugin;
    private boolean initialized = false;
    private boolean isExoticGardenInstalled = false;
    private boolean isChestTerminalInstalled = false;
    private boolean isEmeraldEnchantsInstalled = false;
    private boolean isMcMMOInstalled = false;
    private Function<Block, Optional<ItemStack>> exoticGardenIntegration = b -> Optional.empty();

    public ThirdPartyPluginService(@Nonnull SlimefunPlugin plugin) {
        this.plugin = plugin;
    }

    public void start() {
        String version;
        if (this.initialized) {
            throw new UnsupportedOperationException("Third Party Integrations have already been initialized!");
        }
        this.initialized = true;
        if (this.isPluginInstalled("PlaceholderAPI")) {
            try {
                PlaceholderAPIIntegration hook = new PlaceholderAPIIntegration(this.plugin);
                hook.register();
            }
            catch (Exception | LinkageError x) {
                version = this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI").getDescription().getVersion();
                Slimefun.getLogger().log(Level.WARNING, "Maybe consider updating PlaceholderAPI or Slimefun?");
                Slimefun.getLogger().log(Level.WARNING, x, () -> "Failed to hook into PlaceholderAPI v" + version);
            }
        }
        if (this.isPluginInstalled("EmeraldEnchants")) {
            this.isEmeraldEnchantsInstalled = true;
            Plugin emeraldEnchants = this.plugin.getServer().getPluginManager().getPlugin("EmeraldEnchants");
            EmeraldEnchantsCategory category = new EmeraldEnchantsCategory(new NamespacedKey(emeraldEnchants, "enchantment_guide"));
            category.register();
        }
        if (this.isPluginInstalled("WorldEdit")) {
            try {
                Class.forName("com.sk89q.worldedit.extent.Extent");
                new WorldEditIntegration();
            }
            catch (Exception | LinkageError x) {
                version = this.plugin.getServer().getPluginManager().getPlugin("WorldEdit").getDescription().getVersion();
                Slimefun.getLogger().log(Level.WARNING, "Maybe consider updating WorldEdit or Slimefun?");
                Slimefun.getLogger().log(Level.WARNING, x, () -> "Failed to hook into WorldEdit v" + version);
            }
        }
        if (this.isPluginInstalled("mcMMO")) {
            try {
                new McMMOIntegration(this.plugin);
                this.isMcMMOInstalled = true;
            }
            catch (Exception | LinkageError x) {
                version = this.plugin.getServer().getPluginManager().getPlugin("mcMMO").getDescription().getVersion();
                Slimefun.getLogger().log(Level.WARNING, "Maybe consider updating mcMMO or Slimefun?");
                Slimefun.getLogger().log(Level.WARNING, x, () -> "Failed to hook into mcMMO v" + version);
            }
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (this.isPluginInstalled("ClearLag")) {
                new ClearLagIntegration(this.plugin);
            }
            this.isChestTerminalInstalled = this.isPluginInstalled("ChestTerminal");
        });
    }

    private boolean isPluginInstalled(@Nonnull String hook) {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled(hook)) {
            Slimefun.getLogger().log(Level.INFO, "Hooked into Plugin: {0}", hook);
            return true;
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void loadExoticGarden(Plugin plugin, Function<Block, Optional<ItemStack>> method) {
        if (plugin.getName().equals("ExoticGarden")) {
            this.isExoticGardenInstalled = true;
            this.exoticGardenIntegration = method;
        }
    }

    public boolean isExoticGardenInstalled() {
        return this.isExoticGardenInstalled;
    }

    public boolean isChestTerminalInstalled() {
        return this.isChestTerminalInstalled;
    }

    public boolean isEmeraldEnchantsInstalled() {
        return this.isEmeraldEnchantsInstalled;
    }

    public Optional<ItemStack> harvestExoticGardenPlant(Block block) {
        return this.exoticGardenIntegration.apply(block);
    }

    public boolean isEventFaked(@Nonnull Event event) {
        return this.isMcMMOInstalled && event instanceof FakeBlockBreakEvent;
    }
}

