/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.ActivityCallback;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonNode;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONObject;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

class GitHubActivityConnector
extends GitHubConnector {
    private final ActivityCallback callback;

    @ParametersAreNonnullByDefault
    GitHubActivityConnector(GitHubService github, String repository, ActivityCallback callback) {
        super(github, repository);
        this.callback = callback;
    }

    @Override
    public void onSuccess(@Nonnull JsonNode response) {
        JSONObject object = response.getObject();
        int forks = object.getInt("forks");
        int stars = object.getInt("stargazers_count");
        LocalDateTime lastPush = NumberUtils.parseGitHubDate(object.getString("pushed_at"));
        this.callback.accept(forks, stars, lastPush);
    }

    @Override
    public String getFileName() {
        return "repo";
    }

    @Override
    public String getURLSuffix() {
        return "";
    }
}

