/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomTextureService {
    private final Config config;
    private String version = null;
    private boolean modified = false;

    public CustomTextureService(@Nonnull Config config) {
        this.config = config;
        config.getConfiguration().options().header("This file is used to assign items from Slimefun or any of its addons\nthe 'CustomModelData' NBT tag. This can be used in conjunction with a custom resource pack\nto give items custom textures.\n0 means there is no data assigned to that item.\n\nThere is no official Slimefun resource pack at the moment.");
        config.getConfiguration().options().copyHeader(true);
    }

    public void register(@Nonnull Collection<SlimefunItem> items, boolean save) {
        Validate.notEmpty(items, (String)"items must neither be null or empty.");
        this.config.setDefaultValue("SLIMEFUN_GUIDE", 0);
        this.config.setDefaultValue("_UI_BACKGROUND", 0);
        this.config.setDefaultValue("_UI_INPUT_SLOT", 0);
        this.config.setDefaultValue("_UI_OUTPUT_SLOT", 0);
        this.config.setDefaultValue("_UI_BACK", 0);
        this.config.setDefaultValue("_UI_MENU", 0);
        this.config.setDefaultValue("_UI_SEARCH", 0);
        this.config.setDefaultValue("_UI_WIKI", 0);
        this.config.setDefaultValue("_UI_PREVIOUS_ACTIVE", 0);
        this.config.setDefaultValue("_UI_PREVIOUS_INACTIVE", 0);
        this.config.setDefaultValue("_UI_NEXT_ACTIVE", 0);
        this.config.setDefaultValue("_UI_NEXT_INACTIVE", 0);
        for (SlimefunItem item : items) {
            if (item == null) continue;
            this.config.setDefaultValue(item.getId(), 0);
            if (this.config.getInt(item.getId()) == 0) continue;
            this.modified = true;
        }
        this.version = this.config.getString("version");
        if (save) {
            this.config.save();
        }
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean isActive() {
        return this.modified;
    }

    public int getModelData(@Nonnull String id) {
        Validate.notNull((Object)id, (String)"Cannot get the ModelData for 'null'");
        return this.config.getInt(id);
    }

    public void setTexture(@Nonnull ItemStack item, @Nonnull String id) {
        ItemMeta im = item.getItemMeta();
        this.setTexture(im, id);
        item.setItemMeta(im);
    }

    public void setTexture(@Nonnull ItemMeta im, @Nonnull String id) {
        int data = this.getModelData(id);
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            im.setCustomModelData(data == 0 ? null : Integer.valueOf(data));
        }
    }
}

