/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.core.attributes.MachineTier;
import io.github.thebusybiscuit.slimefun4.core.attributes.MachineType;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactivity;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public final class LoreBuilder {
    public static final String HAZMAT_SUIT_REQUIRED = "&8\u21e8 &4Hazmat Suit required!";
    public static final String RIGHT_CLICK_TO_USE = "&eRight Click&7 to use";
    public static final String RIGHT_CLICK_TO_OPEN = "&eRight Click&7 to open";
    public static final String CROUCH_TO_USE = "&eCrouch&7 to use";
    private static final DecimalFormat hungerFormat = new DecimalFormat("#.0", DecimalFormatSymbols.getInstance(Locale.ROOT));

    private LoreBuilder() {
    }

    public static String radioactive(Radioactivity radioactivity) {
        return radioactivity.getLore();
    }

    public static String machine(MachineTier tier, MachineType type) {
        return (Object)((Object)tier) + " " + (Object)((Object)type);
    }

    public static String speed(float speed) {
        return "&8\u21e8 &b\u26a1 &7Speed: &b" + speed + 'x';
    }

    public static String powerBuffer(int power) {
        return LoreBuilder.power(power, " Buffer");
    }

    public static String powerPerSecond(int power) {
        return LoreBuilder.power(power, "/s");
    }

    public static String power(int power, String suffix) {
        return "&8\u21e8 &e\u26a1 &7" + power + " J" + suffix;
    }

    public static String powerCharged(int charge, int capacity) {
        return "&8\u21e8 &e\u26a1 &7" + charge + " / " + capacity + " J";
    }

    public static String material(String material) {
        return "&8\u21e8 &7Material: &b" + material;
    }

    public static String hunger(double value) {
        return "&7&oRestores &b&o" + hungerFormat.format(value) + " &7&oHunger";
    }
}

