/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets.Jetpack;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.PlayerTask;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class JetpackTask
extends PlayerTask {
    private static final float COST = 0.08f;
    private final Jetpack jetpack;

    public JetpackTask(@Nonnull Player p, @Nonnull Jetpack jetpack) {
        super(p);
        this.jetpack = jetpack;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    @Override
    protected void executeTask() {
        if (this.p.getInventory().getChestplate() == null || this.p.getInventory().getChestplate().getType() == Material.AIR) {
            return;
        }
        if (this.jetpack.removeItemCharge(this.p.getInventory().getChestplate(), 0.08f)) {
            this.p.getWorld().playSound(this.p.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 0.25f, 1.0f);
            this.p.getWorld().playEffect(this.p.getLocation(), Effect.SMOKE, 1, 1);
            this.p.setFallDistance(0.0f);
            Vector vector = new Vector(0, 1, 0);
            vector.multiply(this.jetpack.getThrust());
            vector.add(this.p.getEyeLocation().getDirection().multiply(0.2f));
            this.p.setVelocity(vector);
        } else {
            Bukkit.getScheduler().cancelTask(this.id);
        }
    }
}

