/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.events.PlayerRightClickEvent;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.altar.AltarRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.items.altar.AncientAltar;
import io.github.thebusybiscuit.slimefun4.implementation.items.altar.AncientPedestal;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AncientAltarTask;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AncientAltarListener
implements Listener {
    private AncientAltar altarItem;
    private AncientPedestal pedestalItem;
    private final Set<Location> altarsInUse = new HashSet<Location>();
    private final List<Block> altars = new ArrayList<Block>();
    private final Set<UUID> removedItems = new HashSet<UUID>();

    public AncientAltarListener(SlimefunPlugin plugin, AncientAltar altar, AncientPedestal pedestal) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.altarItem = altar;
        this.pedestalItem = pedestal;
    }

    @Nonnull
    public Set<Location> getAltarsInUse() {
        return this.altarsInUse;
    }

    @Nonnull
    public List<Block> getAltars() {
        return this.altars;
    }

    @EventHandler
    public void onInteract(PlayerRightClickEvent e) {
        if (this.altarItem == null || this.altarItem.isDisabled() || e.useBlock() == Event.Result.DENY) {
            return;
        }
        Optional<Block> blockOptional = e.getClickedBlock();
        if (!blockOptional.isPresent()) {
            return;
        }
        Block b = blockOptional.get();
        if (b.getType() != Material.ENCHANTING_TABLE && b.getType() != Material.DISPENSER) {
            return;
        }
        Optional<SlimefunItem> slimefunBlock = e.getSlimefunBlock();
        if (!slimefunBlock.isPresent()) {
            return;
        }
        String id = slimefunBlock.get().getID();
        if (id.equals(this.pedestalItem.getID())) {
            e.cancel();
            this.usePedestal(b, e.getPlayer());
        } else if (id.equals(this.altarItem.getID())) {
            if (!Slimefun.hasUnlocked(e.getPlayer(), this.altarItem, true) || this.altarsInUse.contains(b.getLocation())) {
                e.cancel();
                return;
            }
            this.altarsInUse.add(b.getLocation());
            e.cancel();
            this.useAltar(b, e.getPlayer());
        }
    }

    private void usePedestal(@Nonnull Block pedestal, @Nonnull Player p) {
        if (this.altarsInUse.contains(pedestal.getLocation())) {
            return;
        }
        if (!SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, pedestal, ProtectableAction.ACCESS_INVENTORIES)) {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "inventory.no-access", true);
            return;
        }
        Optional<Item> stack = this.pedestalItem.getPlacedItem(pedestal);
        if (!stack.isPresent()) {
            if (p.getInventory().getItemInMainHand().getType() != Material.AIR) {
                if (pedestal.getRelative(0, 1, 0).getType() != Material.AIR) {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ANCIENT_PEDESTAL.obstructed", true);
                    return;
                }
                this.pedestalItem.placeItem(p, pedestal);
            }
        } else if (!this.removedItems.contains(stack.get().getUniqueId())) {
            Item entity = stack.get();
            UUID uuid = entity.getUniqueId();
            this.removedItems.add(uuid);
            Slimefun.runSync(() -> this.removedItems.remove(uuid), 30L);
            entity.remove();
            p.getInventory().addItem(new ItemStack[]{this.pedestalItem.getOriginalItemStack(entity)});
            p.playSound(pedestal.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
        }
    }

    private void useAltar(@Nonnull Block altar, @Nonnull Player p) {
        if (!SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, altar, ProtectableAction.ACCESS_INVENTORIES)) {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "inventory.no-access", true);
            return;
        }
        CustomItem catalyst = new CustomItem(p.getInventory().getItemInMainHand(), 1);
        List<Block> pedestals = this.getPedestals(altar);
        if (!this.altars.contains(altar)) {
            this.altars.add(altar);
            if (pedestals.size() == 8) {
                pedestals.forEach(block -> this.altarsInUse.add(block.getLocation()));
                if (catalyst.getType() != Material.AIR) {
                    this.startRitual(p, altar, pedestals, catalyst);
                } else {
                    this.altars.remove(altar);
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ANCIENT_ALTAR.unknown-catalyst", true);
                    for (Block block2 : pedestals) {
                        this.altarsInUse.remove(block2.getLocation());
                    }
                    this.altarsInUse.remove(altar.getLocation());
                }
            } else {
                this.altars.remove(altar);
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ANCIENT_ALTAR.not-enough-pedestals", true, msg -> msg.replace("%pedestals%", String.valueOf(pedestals.size())));
                this.altarsInUse.remove(altar.getLocation());
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void startRitual(Player p, Block b, List<Block> pedestals, ItemStack catalyst) {
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        for (Block pedestal : pedestals) {
            Optional<Item> stack = this.pedestalItem.getPlacedItem(pedestal);
            if (!stack.isPresent()) continue;
            input.add(this.pedestalItem.getOriginalItemStack(stack.get()));
        }
        Optional<ItemStack> result = this.getRecipeOutput(catalyst, input);
        if (result.isPresent()) {
            if (Slimefun.hasUnlocked(p, result.get(), true)) {
                ArrayList<ItemStack> consumed = new ArrayList<ItemStack>();
                consumed.add(catalyst);
                if (p.getGameMode() != GameMode.CREATIVE) {
                    ItemUtils.consumeItem(p.getInventory().getItemInMainHand(), false);
                }
                b.getWorld().playSound(b.getLocation(), Sound.ENTITY_ILLUSIONER_PREPARE_MIRROR, 1.0f, 1.0f);
                AncientAltarTask task = new AncientAltarTask(this, b, this.altarItem.getSpeed(), result.get(), pedestals, consumed, p);
                Slimefun.runSync(task, 10L);
            } else {
                this.altars.remove(b);
                for (Block block : pedestals) {
                    this.altarsInUse.remove(block.getLocation());
                }
                this.altarsInUse.remove(b.getLocation());
            }
        } else {
            this.altars.remove(b);
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ANCIENT_ALTAR.unknown-recipe", true);
            for (Block block : pedestals) {
                this.altarsInUse.remove(block.getLocation());
            }
            this.altarsInUse.remove(b.getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        String id;
        if (this.altarItem == null || this.altarItem.isDisabled()) {
            return;
        }
        Block pedestal = e.getBlockPlaced().getRelative(BlockFace.DOWN);
        if (pedestal.getType() == Material.DISPENSER && (id = BlockStorage.checkID(pedestal)) != null && id.equals(this.pedestalItem.getID())) {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)e.getPlayer(), "messages.cannot-place", true);
            e.setCancelled(true);
        }
    }

    @Nonnull
    private List<Block> getPedestals(@Nonnull Block altar) {
        ArrayList<Block> list = new ArrayList<Block>();
        if (BlockStorage.check(altar.getRelative(2, 0, -2), this.pedestalItem.getID())) {
            list.add(altar.getRelative(2, 0, -2));
        }
        if (BlockStorage.check(altar.getRelative(3, 0, 0), this.pedestalItem.getID())) {
            list.add(altar.getRelative(3, 0, 0));
        }
        if (BlockStorage.check(altar.getRelative(2, 0, 2), this.pedestalItem.getID())) {
            list.add(altar.getRelative(2, 0, 2));
        }
        if (BlockStorage.check(altar.getRelative(0, 0, 3), this.pedestalItem.getID())) {
            list.add(altar.getRelative(0, 0, 3));
        }
        if (BlockStorage.check(altar.getRelative(-2, 0, 2), this.pedestalItem.getID())) {
            list.add(altar.getRelative(-2, 0, 2));
        }
        if (BlockStorage.check(altar.getRelative(-3, 0, 0), this.pedestalItem.getID())) {
            list.add(altar.getRelative(-3, 0, 0));
        }
        if (BlockStorage.check(altar.getRelative(-2, 0, -2), this.pedestalItem.getID())) {
            list.add(altar.getRelative(-2, 0, -2));
        }
        if (BlockStorage.check(altar.getRelative(0, 0, -3), this.pedestalItem.getID())) {
            list.add(altar.getRelative(0, 0, -3));
        }
        return list;
    }

    @Nonnull
    public Optional<ItemStack> getRecipeOutput(@Nonnull ItemStack catalyst, @Nonnull List<ItemStack> inputs) {
        if (inputs.size() != 8) {
            return Optional.empty();
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(catalyst);
        List<ItemStackWrapper> items = ItemStackWrapper.wrapList(inputs);
        if (SlimefunUtils.isItemSimilar(wrapper, SlimefunItems.BROKEN_SPAWNER, false, false)) {
            if (!this.checkRecipe(SlimefunItems.BROKEN_SPAWNER, items).isPresent()) {
                return Optional.empty();
            }
            ItemStack spawner = SlimefunItems.REPAIRED_SPAWNER.clone();
            ItemMeta im = spawner.getItemMeta();
            im.setLore(Arrays.asList((String)wrapper.getItemMeta().getLore().get(0)));
            spawner.setItemMeta(im);
            return Optional.of(spawner);
        }
        return this.checkRecipe(wrapper, items);
    }

    @Nonnull
    private Optional<ItemStack> checkRecipe(@Nonnull ItemStack catalyst, @Nonnull List<ItemStackWrapper> items) {
        for (AltarRecipe recipe : this.altarItem.getRecipes()) {
            Optional<ItemStack> optional;
            if (!SlimefunUtils.isItemSimilar(catalyst, recipe.getCatalyst(), true) || !(optional = this.checkPedestals(items, recipe)).isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<ItemStack> checkPedestals(@Nonnull List<ItemStackWrapper> items, @Nonnull AltarRecipe recipe) {
        for (int i = 0; i < 8; ++i) {
            if (!SlimefunUtils.isItemSimilar(items.get(i), recipe.getInput().get(0), true)) continue;
            for (int j = 1; j < 8 && SlimefunUtils.isItemSimilar(items.get((i + j) % items.size()), recipe.getInput().get(j), true); ++j) {
                if (j != 7) continue;
                return Optional.of(recipe.getOutput());
            }
        }
        return Optional.empty();
    }
}

