/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TapeMeasure
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    private final NamespacedKey key = new NamespacedKey((Plugin)SlimefunPlugin.instance(), "anchor");
    private final DecimalFormat format = new DecimalFormat("##.###");

    public TapeMeasure(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            if (e.getClickedBlock().isPresent()) {
                Block block = e.getClickedBlock().get();
                if (e.getPlayer().isSneaking()) {
                    this.setAnchor(e.getPlayer(), e.getItem(), block);
                } else {
                    this.measure(e.getPlayer(), e.getItem(), block);
                }
            }
        };
    }

    private void setAnchor(Player p, ItemStack item, Block block) {
        ItemMeta meta = item.getItemMeta();
        JsonObject json = new JsonObject();
        json.addProperty("world", block.getWorld().getUID().toString());
        json.addProperty("x", (Number)block.getX());
        json.addProperty("y", (Number)block.getY());
        json.addProperty("z", (Number)block.getZ());
        meta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)json.toString());
        String anchor = block.getX() + " | " + block.getY() + " | " + block.getZ();
        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.tape-measure.anchor-set", msg -> msg.replace("%anchor%", anchor));
        item.setItemMeta(meta);
    }

    private Optional<Location> getAnchor(Player p, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        String data = (String)meta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
        if (data != null) {
            JsonObject json = new JsonParser().parse(data).getAsJsonObject();
            UUID uuid = UUID.fromString(json.get("world").getAsString());
            if (p.getWorld().getUID().equals(uuid)) {
                int x = json.get("x").getAsInt();
                int y = json.get("y").getAsInt();
                int z = json.get("z").getAsInt();
                Location loc = new Location(p.getWorld(), (double)x, (double)y, (double)z);
                return Optional.of(loc);
            }
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.tape-measure.wrong-world");
            return Optional.empty();
        }
        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.tape-measure.no-anchor");
        return Optional.empty();
    }

    private void measure(Player p, ItemStack item, Block block) {
        Optional<Location> anchor = this.getAnchor(p, item);
        if (anchor.isPresent()) {
            Location loc = anchor.get();
            double distance = loc.distance(block.getLocation());
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.tape-measure.distance", msg -> msg.replace("%distance%", this.format.format(distance)));
        }
    }
}

