/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.localization;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public final class Language {
    private final String id;
    private final ItemStack item;
    private double progress = -1.0;
    private FileConfiguration messages;
    private FileConfiguration researches;
    private FileConfiguration resources;
    private FileConfiguration categories;
    private FileConfiguration recipeTypes;

    public Language(@Nonnull String id, @Nonnull String hash) {
        Validate.notNull((Object)id, (String)"A Language must have an id that is not null!");
        Validate.notNull((Object)hash, (String)"A Language must have a texture that is not null!");
        this.id = id;
        this.item = SlimefunUtils.getCustomHead(hash);
        SlimefunPlugin.getItemTextureService().setTexture(this.item, "_UI_LANGUAGE_" + id.toUpperCase(Locale.ROOT));
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public double getTranslationProgress() {
        if (this.id.equals("en")) {
            return 100.0;
        }
        if (this.progress < 0.0) {
            this.progress = SlimefunPlugin.getLocalization().calculateProgress(this);
        }
        return this.progress;
    }

    @Nullable
    FileConfiguration getMessagesFile() {
        return this.messages;
    }

    @Nullable
    FileConfiguration getResearchesFile() {
        return this.researches;
    }

    @Nullable
    FileConfiguration getResourcesFile() {
        return this.resources;
    }

    @Nullable
    FileConfiguration getCategoriesFile() {
        return this.categories;
    }

    @Nullable
    FileConfiguration getRecipeTypesFile() {
        return this.recipeTypes;
    }

    public void setMessagesFile(@Nonnull FileConfiguration config) {
        Validate.notNull((Object)config);
        this.messages = config;
    }

    public void setResearchesFile(@Nonnull FileConfiguration config) {
        Validate.notNull((Object)config);
        this.researches = config;
    }

    public void setResourcesFile(@Nonnull FileConfiguration config) {
        Validate.notNull((Object)config);
        this.resources = config;
    }

    public void setCategoriesFile(@Nonnull FileConfiguration config) {
        Validate.notNull((Object)config);
        this.categories = config;
    }

    public void setRecipeTypesFile(@Nonnull FileConfiguration config) {
        Validate.notNull((Object)config);
        this.recipeTypes = config;
    }

    @Nonnull
    public ItemStack getItem() {
        return this.item;
    }

    @Nonnull
    public String getName(@Nonnull Player p) {
        String name = SlimefunPlugin.getLocalization().getMessage(p, "languages." + this.id);
        return name != null ? name : this.toString();
    }

    public boolean isDefault() {
        return this == SlimefunPlugin.getLocalization().getDefaultLanguage();
    }

    public String toString() {
        return "Language {id= " + this.id + ", default=" + this.isDefault() + " }";
    }

    @Nonnull
    public FileConfiguration[] getFiles() {
        return new FileConfiguration[]{this.getMessagesFile(), this.getCategoriesFile(), this.getResearchesFile(), this.getResourcesFile()};
    }
}

