/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.player;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class PlayerBackpack {
    private final PlayerProfile profile;
    private final int id;
    private final Config cfg;
    private Inventory inventory;
    private int size;

    public PlayerBackpack(@Nonnull PlayerProfile profile, int id) {
        this(profile, id, profile.getConfig().getInt("backpacks." + id + ".size"));
        for (int i = 0; i < this.size; ++i) {
            this.inventory.setItem(i, this.cfg.getItem("backpacks." + id + ".contents." + i));
        }
    }

    public PlayerBackpack(@Nonnull PlayerProfile profile, int id, int size) {
        if (size < 9 || size > 54 || size % 9 != 0) {
            throw new IllegalArgumentException("Invalid size! Size must be one of: [9, 18, 27, 36, 45, 54]");
        }
        this.profile = profile;
        this.id = id;
        this.cfg = profile.getConfig();
        this.size = size;
        this.cfg.setValue("backpacks." + id + ".size", size);
        this.markDirty();
        this.inventory = Bukkit.createInventory(null, (int)size, (String)("Backpack [" + size + " Slots]"));
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public PlayerProfile getOwner() {
        return this.profile;
    }

    public int getSize() {
        return this.size;
    }

    @Nonnull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void open(Player ... players) {
        Slimefun.runSync(() -> {
            for (Player p : players) {
                p.openInventory(this.inventory);
            }
        });
    }

    public void setSize(int size) {
        if (size < 9 || size > 54 || size % 9 != 0) {
            throw new IllegalArgumentException("Invalid size! Size must be one of: [9, 18, 27, 36, 45, 54]");
        }
        this.size = size;
        this.cfg.setValue("backpacks." + this.id + ".size", size);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)("Backpack [" + size + " Slots]"));
        for (int slot = 0; slot < this.inventory.getSize(); ++slot) {
            inv.setItem(slot, this.inventory.getItem(slot));
        }
        this.inventory = inv;
        this.markDirty();
    }

    public void save() {
        for (int i = 0; i < this.size; ++i) {
            this.cfg.setValue("backpacks." + this.id + ".contents." + i, this.inventory.getItem(i));
        }
    }

    public void markDirty() {
        this.profile.markDirty();
    }
}

