/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest;

import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kong.unirest.CacheManager;
import kong.unirest.HttpRequest;
import kong.unirest.HttpResponse;

public interface Cache {
    public <T> HttpResponse get(Key var1, Supplier<HttpResponse<T>> var2);

    public <T> CompletableFuture getAsync(Key var1, Supplier<CompletableFuture<HttpResponse<T>>> var2);

    public static Builder builder() {
        return new Builder();
    }

    public static interface Key {
        public boolean equals(Object var1);

        public int hashCode();

        public Instant getTime();
    }

    @FunctionalInterface
    public static interface KeyGenerator {
        public Key apply(HttpRequest var1, Boolean var2, Class<?> var3);
    }

    public static class Builder {
        private int depth = 100;
        private long ttl = 0L;
        private Cache backing;
        private KeyGenerator keyGen;

        CacheManager build() {
            if (this.backing != null) {
                return new CacheManager(this.backing, this.keyGen);
            }
            return new CacheManager(this.depth, this.ttl, this.keyGen);
        }

        public Builder depth(int value) {
            this.depth = value;
            return this;
        }

        public Builder maxAge(long number, TimeUnit units) {
            this.ttl = units.toMillis(number);
            return this;
        }

        public Builder backingCache(Cache cache) {
            this.backing = cache;
            return this;
        }

        public Builder withKeyGen(KeyGenerator keyGenerator) {
            this.keyGen = keyGenerator;
            return this;
        }
    }
}

