/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.cscorelib2.recipes.MinecraftRecipe;
import me.mrCookieSlime.Slimefun.cscorelib2.recipes.RecipeSnapshot;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class MinecraftRecipeService {
    private final Plugin plugin;
    private final List<Consumer<RecipeSnapshot>> subscriptions = new LinkedList<Consumer<RecipeSnapshot>>();
    private RecipeSnapshot snapshot;

    public MinecraftRecipeService(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    public void refresh() {
        this.snapshot = new RecipeSnapshot(this.plugin);
        for (Consumer<RecipeSnapshot> subscriber : this.subscriptions) {
            subscriber.accept(this.snapshot);
        }
    }

    public void subscribe(@Nonnull Consumer<RecipeSnapshot> subscription) {
        Validate.notNull(subscription, (String)"Callback must not be null!");
        this.subscriptions.add(subscription);
    }

    @Nonnull
    public Optional<ItemStack> getFurnaceOutput(@Nullable ItemStack input) {
        if (this.snapshot == null || input == null) {
            return Optional.empty();
        }
        return this.snapshot.getRecipeOutput(MinecraftRecipe.FURNACE, input);
    }

    public boolean isSmeltable(@Nullable ItemStack input) {
        return this.getFurnaceOutput(input).isPresent();
    }

    @Nonnull
    public RecipeChoice[] getRecipeShape(@Nonnull Recipe recipe) {
        Validate.notNull((Object)recipe, (String)"Recipe must not be null!");
        if (recipe instanceof ShapedRecipe) {
            LinkedList choices = new LinkedList();
            for (String row : ((ShapedRecipe)recipe).getShape()) {
                int columns = row.toCharArray().length;
                for (char key : row.toCharArray()) {
                    choices.add(((ShapedRecipe)recipe).getChoiceMap().get(Character.valueOf(key)));
                }
                while (columns < 3) {
                    choices.add(null);
                    ++columns;
                }
            }
            return choices.toArray(new RecipeChoice[0]);
        }
        return this.snapshot.getRecipeInput(recipe);
    }

    @Nonnull
    public Recipe[] getRecipesFor(@Nullable ItemStack item) {
        if (this.snapshot == null || item == null) {
            return new Recipe[0];
        }
        return this.snapshot.getRecipesFor(item).toArray(new Recipe[0]);
    }
}

