/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.apache.commons.lang.Validate;

public class BackupService
implements Runnable {
    private static final int MAX_BACKUPS = 20;
    private final DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm", Locale.ROOT);
    private final File directory = new File("data-storage/Slimefun/block-backups");

    @Override
    public void run() {
        block20: {
            File file;
            List<File> backups = Arrays.asList(this.directory.listFiles());
            if (backups.size() > 20) {
                try {
                    this.purgeBackups(backups);
                }
                catch (IOException e) {
                    Slimefun.getLogger().log(Level.WARNING, "Could not delete an old backup", e);
                }
            }
            if (!(file = new File(this.directory, this.format.format(LocalDateTime.now()) + ".zip")).exists()) {
                try {
                    if (file.createNewFile()) {
                        try (ZipOutputStream output = new ZipOutputStream(new FileOutputStream(file));){
                            this.createBackup(output);
                        }
                        Slimefun.getLogger().log(Level.INFO, "Backed up Slimefun data to: {0}", file.getName());
                        break block20;
                    }
                    Slimefun.getLogger().log(Level.WARNING, "Could not create backup-file: {0}", file.getName());
                }
                catch (IOException x) {
                    Slimefun.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while creating a backup for Slimefun " + SlimefunPlugin.getVersion());
                }
            }
        }
    }

    private void createBackup(@Nonnull ZipOutputStream output) throws IOException {
        Validate.notNull((Object)output, (String)"The Output Stream cannot be null!");
        for (File folder : new File("data-storage/Slimefun/stored-blocks/").listFiles()) {
            this.addDirectory(output, folder, "stored-blocks/" + folder.getName());
        }
        this.addDirectory(output, new File("data-storage/Slimefun/universal-inventories/"), "universal-inventories");
        this.addDirectory(output, new File("data-storage/Slimefun/stored-inventories/"), "stored-inventories");
        File chunks = new File("data-storage/Slimefun/stored-chunks/chunks.sfc");
        if (chunks.exists()) {
            byte[] buffer = new byte[1024];
            ZipEntry entry = new ZipEntry("stored-chunks/chunks.sfc");
            output.putNextEntry(entry);
            try (FileInputStream input = new FileInputStream(chunks);){
                int length;
                while ((length = input.read(buffer)) > 0) {
                    output.write(buffer, 0, length);
                }
            }
            output.closeEntry();
        }
    }

    private void addDirectory(@Nonnull ZipOutputStream output, @Nonnull File directory, @Nonnull String zipPath) throws IOException {
        byte[] buffer = new byte[1024];
        for (File file : directory.listFiles()) {
            ZipEntry entry = new ZipEntry(zipPath + '/' + file.getName());
            output.putNextEntry(entry);
            try (FileInputStream input = new FileInputStream(file);){
                int length;
                while ((length = input.read(buffer)) > 0) {
                    output.write(buffer, 0, length);
                }
            }
            output.closeEntry();
        }
    }

    private void purgeBackups(@Nonnull List<File> backups) throws IOException {
        Collections.sort(backups, (a, b) -> {
            LocalDateTime time1 = LocalDateTime.parse(a.getName().substring(0, a.getName().length() - 4), this.format);
            LocalDateTime time2 = LocalDateTime.parse(b.getName().substring(0, b.getName().length() - 4), this.format);
            return time2.compareTo(time1);
        });
        for (int i = backups.size() - 20; i > 0; --i) {
            Files.delete(backups.get(i).toPath());
        }
    }
}

