/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.apache.commons.lang.Validate;

public class ItemSetting<T> {
    private final String key;
    private final T defaultValue;
    private T value;

    @ParametersAreNonnullByDefault
    public ItemSetting(String key, T defaultValue) {
        Validate.notNull((Object)key, (String)"The key of an ItemSetting is not allowed to be null!");
        Validate.notNull(defaultValue, (String)"The default value of an ItemSetting is not allowed to be null!");
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public boolean validateInput(T input) {
        return input != null;
    }

    public void update(@Nonnull T newValue) {
        if (!this.validateInput(newValue)) {
            throw new IllegalArgumentException("The passed value was not valid. (Maybe null?)");
        }
        this.value = newValue;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public T getValue() {
        Validate.notNull(this.value, (String)"An ItemSetting was invoked but was not initialized yet.");
        return this.value;
    }

    @Nonnull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isType(@Nonnull Class<?> c) {
        return c.isInstance(this.defaultValue);
    }

    public void load(@Nonnull SlimefunItem item) {
        SlimefunPlugin.getItemCfg().setDefaultValue(item.getID() + '.' + this.getKey(), this.getDefaultValue());
        Object configuredValue = SlimefunPlugin.getItemCfg().getValue(item.getID() + '.' + this.getKey());
        if (this.defaultValue.getClass().isInstance(configuredValue)) {
            this.value = configuredValue;
        } else {
            this.value = this.defaultValue;
            String found = configuredValue == null ? "null" : configuredValue.getClass().getSimpleName();
            Slimefun.getLogger().log(Level.WARNING, "Slimefun has found an invalid config setting in your Items.yml!");
            Slimefun.getLogger().log(Level.WARNING, "Please only use settings that are valid.");
            Slimefun.getLogger().log(Level.WARNING, "  at \"{0}.{1}\"", new Object[]{item.getID(), this.getKey()});
            Slimefun.getLogger().log(Level.WARNING, "Expected \"{0}\" but found: \"{1}\"", new Object[]{this.defaultValue.getClass().getSimpleName(), found});
        }
    }
}

