/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import kong.unirest.AsyncClient;
import kong.unirest.Config;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestSummary;
import kong.unirest.HttpResponse;
import kong.unirest.MetricContext;
import kong.unirest.RawResponse;
import kong.unirest.UnirestConfigException;
import kong.unirest.UnirestException;
import kong.unirest.apache.ApacheNoRedirectStrategy;
import kong.unirest.apache.ApacheResponse;
import kong.unirest.apache.AsyncIdleConnectionMonitorThread;
import kong.unirest.apache.BaseApacheClient;
import kong.unirest.apache.RequestConfigFactory;
import kong.unirest.apache.RequestOptions;
import kong.unirest.apache.RequestPrep;
import kong.unirest.apache.Util;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;

public class ApacheAsyncClient
extends BaseApacheClient
implements AsyncClient {
    private final HttpAsyncClient client;
    private AsyncIdleConnectionMonitorThread syncMonitor;
    private PoolingNHttpClientConnectionManager manager;
    private Config config;
    private boolean hookset;

    public ApacheAsyncClient(Config config) {
        this.config = config;
        try {
            this.manager = this.createConnectionManager();
            this.manager.setMaxTotal(config.getMaxConnections());
            this.manager.setDefaultMaxPerRoute(config.getMaxPerRoutes());
            HttpAsyncClientBuilder ab = HttpAsyncClientBuilder.create().setDefaultRequestConfig(RequestOptions.toRequestConfig(config)).setConnectionManager(this.manager).setDefaultCredentialsProvider(this.toApacheCreds(config.getProxy())).useSystemProperties();
            this.setOptions(ab);
            CloseableHttpAsyncClient build = ab.build();
            build.start();
            this.syncMonitor = new AsyncIdleConnectionMonitorThread(this.manager);
            this.syncMonitor.tryStart();
            this.client = build;
            if (config.shouldAddShutdownHook()) {
                this.registerShutdownHook();
            }
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
    }

    public ApacheAsyncClient(HttpAsyncClient client, Config config) {
        this.config = config;
        this.client = client;
    }

    @Deprecated
    public ApacheAsyncClient(HttpAsyncClient client, Config config, PoolingNHttpClientConnectionManager manager, AsyncIdleConnectionMonitorThread monitor) {
        Objects.requireNonNull(client, "Client may not be null");
        this.config = config;
        this.client = client;
        this.syncMonitor = monitor;
        this.manager = manager;
    }

    @Override
    public void registerShutdownHook() {
        if (!this.hookset) {
            this.hookset = true;
            Runtime.getRuntime().addShutdownHook(new Thread(this::close, "Unirest Apache Async Client Shutdown Hook"));
        }
    }

    private void setOptions(HttpAsyncClientBuilder ab) {
        if (!this.config.isVerifySsl()) {
            this.disableSsl(ab);
        }
        if (this.config.useSystemProperties()) {
            ab.useSystemProperties();
        }
        if (!this.config.getFollowRedirects()) {
            ab.setRedirectStrategy(new ApacheNoRedirectStrategy());
        }
        if (!this.config.getEnabledCookieManagement()) {
            ab.disableCookieManagement();
        }
        this.config.getInterceptor().forEach(ab::addInterceptorFirst);
    }

    private PoolingNHttpClientConnectionManager createConnectionManager() throws Exception {
        return new PoolingNHttpClientConnectionManager(new DefaultConnectingIOReactor(), null, this.getRegistry(), null, null, this.config.getTTL(), TimeUnit.MILLISECONDS);
    }

    private Registry<SchemeIOSessionStrategy> getRegistry() throws Exception {
        if (this.config.isVerifySsl()) {
            return RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)SSLIOSessionStrategy.getDefaultStrategy())).build();
        }
        return RegistryBuilder.create().register("http", NoopIOSessionStrategy.INSTANCE).register("https", (NoopIOSessionStrategy)((Object)new SSLIOSessionStrategy(new SSLContextBuilder().loadTrustMaterial(null, (x509Certificates, s) -> true).build(), NoopHostnameVerifier.INSTANCE))).build();
    }

    private void disableSsl(HttpAsyncClientBuilder ab) {
        try {
            ab.setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE);
            ab.setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build());
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> request(HttpRequest request, final Function<RawResponse, HttpResponse<T>> transformer, final CompletableFuture<HttpResponse<T>> callback) {
        Objects.requireNonNull(callback);
        this.config.getUniInterceptor().onRequest(request, this.config);
        HttpRequestBase requestObj = new RequestPrep(request, this.config, true).prepare(this.configFactory);
        final HttpRequestSummary reqSum = request.toSummary();
        final MetricContext metric = this.config.getMetric().begin(reqSum);
        this.client.execute(requestObj, new FutureCallback<org.apache.http.HttpResponse>(){

            @Override
            public void completed(org.apache.http.HttpResponse httpResponse) {
                ApacheResponse t = new ApacheResponse(httpResponse, ApacheAsyncClient.this.config);
                metric.complete(t.toSummary(), null);
                HttpResponse response = ApacheAsyncClient.this.transformBody(transformer, t);
                ApacheAsyncClient.this.config.getUniInterceptor().onResponse(response, reqSum, ApacheAsyncClient.this.config);
                callback.complete(response);
            }

            @Override
            public void failed(Exception e) {
                metric.complete(null, e);
                try {
                    HttpResponse<?> r = ApacheAsyncClient.this.config.getUniInterceptor().onFail(e, reqSum, ApacheAsyncClient.this.config);
                    callback.complete(r);
                }
                catch (Exception ee) {
                    callback.completeExceptionally(e);
                }
            }

            @Override
            public void cancelled() {
                UnirestException canceled = new UnirestException("canceled");
                metric.complete(null, canceled);
                callback.completeExceptionally(canceled);
                ApacheAsyncClient.this.config.getUniInterceptor().onFail(canceled, reqSum, ApacheAsyncClient.this.config);
            }
        });
        return callback;
    }

    @Override
    public boolean isRunning() {
        return Util.tryCast(this.client, CloseableHttpAsyncClient.class).map(CloseableHttpAsyncClient::isRunning).orElse(true);
    }

    public HttpAsyncClient getClient() {
        return this.client;
    }

    @Override
    public Stream<Exception> close() {
        return Util.collectExceptions(Util.tryCast(this.client, CloseableHttpAsyncClient.class).filter(c -> c.isRunning()).map(c -> Util.tryDo(c, d -> d.close())).filter(c -> c.isPresent()).map(c -> (Exception)c.get()), Util.tryDo(this.manager, m -> m.shutdown()), Util.tryDo(this.syncMonitor, m -> m.interrupt()));
    }

    public static Builder builder(HttpAsyncClient client) {
        return new Builder(client);
    }

    public static class Builder
    implements Function<Config, AsyncClient> {
        private HttpAsyncClient asyncClient;
        private RequestConfigFactory cf;

        public Builder(HttpAsyncClient client) {
            this.asyncClient = client;
        }

        @Override
        public AsyncClient apply(Config config) {
            ApacheAsyncClient client = new ApacheAsyncClient(this.asyncClient, config);
            if (this.cf != null) {
                client.setConfigFactory(this.cf);
            }
            return client;
        }

        public Builder withRequestConfig(RequestConfigFactory factory) {
            Objects.requireNonNull(factory);
            this.cf = factory;
            return this;
        }
    }
}

