/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.EnhancedFurnace;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Furnace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EnhancedFurnaceListener
implements Listener {
    public EnhancedFurnaceListener(SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFuelBurn(FurnaceBurnEvent e) {
        if (e.getBlock().getType() != Material.FURNACE) {
            return;
        }
        SlimefunItem furnace = BlockStorage.check(e.getBlock());
        if (furnace instanceof EnhancedFurnace && ((EnhancedFurnace)furnace).getFuelEfficiency() > 0) {
            int burnTime = e.getBurnTime();
            int newBurnTime = ((EnhancedFurnace)furnace).getFuelEfficiency() * burnTime;
            e.setBurnTime(Math.min(newBurnTime, 32766));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemSmelt(FurnaceSmeltEvent e) {
        BlockState state;
        if (e.getBlock().getType() != Material.FURNACE) {
            return;
        }
        SlimefunItem sfItem = BlockStorage.check(e.getBlock());
        if (sfItem instanceof EnhancedFurnace && (state = PaperLib.getBlockState(e.getBlock(), false).getState()) instanceof Furnace) {
            FurnaceInventory inventory = ((Furnace)state).getInventory();
            int amount = inventory.getSmelting().getType().toString().endsWith("_ORE") ? ((EnhancedFurnace)sfItem).getOutput() : 1;
            Optional<ItemStack> result = SlimefunPlugin.getMinecraftRecipeService().getFurnaceOutput(inventory.getSmelting());
            if (result.isPresent()) {
                ItemStack item = result.get();
                int previous = inventory.getResult() != null ? inventory.getResult().getAmount() : 0;
                amount = Math.min(item.getMaxStackSize() - previous, amount);
                e.setResult(new ItemStack(item.getType(), amount));
            }
        }
    }
}

