/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class AutoSavingService {
    private int interval;

    public void start(SlimefunPlugin plugin, int interval) {
        this.interval = interval;
        plugin.getServer().getScheduler().runTaskTimer((Plugin)plugin, this::saveAllPlayers, 2000L, (long)interval * 60L * 20L);
        plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, this::saveAllBlocks, 2000L, (long)interval * 60L * 20L);
    }

    private void saveAllPlayers() {
        Iterator<PlayerProfile> iterator = PlayerProfile.iterator();
        int players = 0;
        while (iterator.hasNext()) {
            PlayerProfile profile = iterator.next();
            if (profile.isDirty()) {
                ++players;
                profile.save();
            }
            if (!profile.isMarkedForDeletion()) continue;
            iterator.remove();
        }
        if (players > 0) {
            Slimefun.getLogger().log(Level.INFO, "Auto-saved all player data for {0} player(s)!", players);
        }
    }

    private void saveAllBlocks() {
        HashSet<BlockStorage> worlds = new HashSet<BlockStorage>();
        for (World world : Bukkit.getWorlds()) {
            if (!BlockStorage.isWorldRegistered(world.getName())) continue;
            BlockStorage storage = BlockStorage.getStorage(world);
            storage.computeChanges();
            if (storage.getChanges() <= 0) continue;
            worlds.add(storage);
        }
        if (!worlds.isEmpty()) {
            Slimefun.getLogger().log(Level.INFO, "Auto-saving block data... (Next auto-save: {0}m)", this.interval);
            for (BlockStorage storage : worlds) {
                storage.save(false);
            }
        }
        BlockStorage.saveChunks();
    }
}

