/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.GeneratorTicker;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractEnergyProvider
extends SlimefunItem
implements InventoryBlock,
RecipeDisplayItem,
EnergyNetProvider {
    protected final Set<MachineFuel> fuelTypes = new HashSet<MachineFuel>();

    protected AbstractEnergyProvider(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    public abstract String getInventoryTitle();

    public abstract ItemStack getProgressBar();

    public abstract int getEnergyProduction();

    protected abstract void registerDefaultFuelTypes();

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.GENERATOR;
    }

    @Deprecated
    protected GeneratorTicker onTick() {
        return null;
    }

    @Override
    public int getGeneratedOutput(Location l, Config data) {
        if (this.generatorTicker != null) {
            return (int)this.generatorTicker.generateEnergy(l, this, data);
        }
        return 0;
    }

    @Override
    public boolean willExplode(Location l, Config data) {
        if (this.generatorTicker != null) {
            return this.generatorTicker.explode(l);
        }
        return false;
    }

    @Override
    public void preRegister() {
        super.preRegister();
        GeneratorTicker ticker = this.onTick();
        if (ticker != null) {
            this.addItemHandler(ticker);
        }
    }

    public void registerFuel(MachineFuel fuel) {
        this.fuelTypes.add(fuel);
    }

    public Set<MachineFuel> getFuelTypes() {
        return this.fuelTypes;
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.generator";
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.fuelTypes) {
            ItemStack item = fuel.getInput().clone();
            ItemMeta im = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColors.color("&8\u21e8 &7Lasts " + NumberUtils.getTimeLeft(fuel.getTicks() / 2)));
            lore.add(ChatColors.color("&8\u21e8 &e\u26a1 &7" + this.getEnergyProduction() * 2) + " J/s");
            lore.add(ChatColors.color("&8\u21e8 &e\u26a1 &7" + DoubleHandler.getFancyDouble((double)fuel.getTicks() * (double)this.getEnergyProduction()) + " J in total"));
            im.setLore(lore);
            item.setItemMeta(im);
            list.add(item);
        }
        return list;
    }
}

