/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.api.events.AndroidMineEvent;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidInstance;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import java.util.Collection;
import java.util.UUID;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.materials.MaterialCollections;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public abstract class MinerAndroid
extends ProgrammableAndroid {
    private final ItemStack effectivePickaxe = new ItemStack(Material.DIAMOND_PICKAXE);

    public MinerAndroid(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public AndroidType getAndroidType() {
        return AndroidType.MINER;
    }

    @Override
    protected void dig(Block b, BlockMenu menu, Block block) {
        Collection drops = block.getDrops(this.effectivePickaxe);
        if (!MaterialCollections.getAllUnbreakableBlocks().contains(block.getType()) && !drops.isEmpty() && SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo(b.getLocation(), "owner"))), block.getLocation(), ProtectableAction.BREAK_BLOCK)) {
            AndroidMineEvent event = new AndroidMineEvent(block, new AndroidInstance(this, b));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            String blockId = BlockStorage.checkID(block);
            if (blockId == null) {
                for (ItemStack drop : drops) {
                    if (!menu.fits(drop, this.getOutputSlots())) continue;
                    menu.pushItem(drop, this.getOutputSlots());
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
                    block.setType(Material.AIR);
                }
            }
        }
    }

    @Override
    protected void moveAndDig(Block b, BlockMenu menu, BlockFace face, Block block) {
        Collection drops = block.getDrops(this.effectivePickaxe);
        if (!MaterialCollections.getAllUnbreakableBlocks().contains(block.getType()) && !drops.isEmpty() && SlimefunPlugin.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)UUID.fromString(BlockStorage.getLocationInfo(b.getLocation(), "owner"))), block.getLocation(), ProtectableAction.BREAK_BLOCK)) {
            AndroidMineEvent event = new AndroidMineEvent(block, new AndroidInstance(this, b));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            SlimefunItem blockId = BlockStorage.check(block);
            if (blockId == null) {
                for (ItemStack drop : drops) {
                    if (!menu.fits(drop, this.getOutputSlots())) continue;
                    menu.pushItem(drop, this.getOutputSlots());
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
                    block.setType(Material.AIR);
                    this.move(b, face, block);
                    b.setType(Material.AIR);
                    BlockStorage.moveBlockInfo(b.getLocation(), block.getLocation());
                }
            }
        } else {
            this.move(b, face, block);
        }
    }
}

