/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils.holograms;

import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public final class SimpleHologram {
    private SimpleHologram() {
    }

    public static void update(Block b, String name) {
        Slimefun.runSync(() -> {
            ArmorStand hologram = SimpleHologram.getArmorStand(b, true);
            hologram.setCustomName(ChatColors.color(name));
        });
    }

    public static void remove(Block b) {
        Slimefun.runSync(() -> {
            ArmorStand hologram = SimpleHologram.getArmorStand(b, false);
            if (hologram != null) {
                hologram.remove();
            }
        });
    }

    private static ArmorStand getArmorStand(Block b, boolean createIfNoneExists) {
        Location l = new Location(b.getWorld(), (double)b.getX() + 0.5, (double)((float)b.getY() + 0.7f), (double)b.getZ() + 0.5);
        for (Entity n : l.getChunk().getEntities()) {
            if (!(n instanceof ArmorStand) || !(l.distanceSquared(n.getLocation()) < 0.4) || n.getCustomName() == null) continue;
            return (ArmorStand)n;
        }
        if (!createIfNoneExists) {
            return null;
        }
        return SimpleHologram.create(l);
    }

    public static ArmorStand create(Location l) {
        ArmorStand armorStand = (ArmorStand)l.getWorld().spawnEntity(l, EntityType.ARMOR_STAND);
        armorStand.setVisible(false);
        armorStand.setSilent(true);
        armorStand.setMarker(true);
        armorStand.setGravity(false);
        armorStand.setBasePlate(false);
        armorStand.setCustomNameVisible(true);
        armorStand.setRemoveWhenFarAway(false);
        return armorStand;
    }
}

