/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.HashSet;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public abstract class CropGrowthAccelerator
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent {
    private final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private final Set<Material> crops = new HashSet<Material>();
    private static final ItemStack organicFertilizer = new ItemStackWrapper(SlimefunItems.FERTILIZER);

    public CropGrowthAccelerator(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.crops.add(Material.WHEAT);
        this.crops.add(Material.POTATOES);
        this.crops.add(Material.CARROTS);
        this.crops.add(Material.NETHER_WART);
        this.crops.add(Material.BEETROOTS);
        this.crops.add(Material.COCOA);
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            this.crops.add(Material.SWEET_BERRY_BUSH);
        }
        this.createPreset(this, this::constructMenu);
        CropGrowthAccelerator.registerBlockHandler(this.getID(), (p, b, tool, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                for (int slot : this.getInputSlots()) {
                    if (inv.getItemInSlot(slot) == null) continue;
                    b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                    inv.replaceExistingItem(slot, null);
                }
            }
            return true;
        });
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : this.border) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.CYAN_STAINED_GLASS_PANE), " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public abstract int getEnergyConsumption();

    public abstract int getRadius();

    public abstract int getSpeed();

    @Override
    public int[] getInputSlots() {
        return new int[]{10, 11, 12, 13, 14, 15, 16};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    @Override
    public int getCapacity() {
        return 1024;
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                CropGrowthAccelerator.this.tick(b);
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
    }

    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        if (ChargableBlock.getCharge(b) >= this.getEnergyConsumption()) {
            for (int x = -this.getRadius(); x <= this.getRadius(); ++x) {
                for (int z = -this.getRadius(); z <= this.getRadius(); ++z) {
                    Block block = b.getRelative(x, 0, z);
                    if (!this.crops.contains(block.getType()) || !this.grow(b, inv, block)) continue;
                    return;
                }
            }
        }
    }

    private boolean grow(Block machine, BlockMenu inv, Block crop) {
        Ageable ageable = (Ageable)crop.getBlockData();
        if (ageable.getAge() < ageable.getMaximumAge()) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), organicFertilizer, false)) continue;
                ChargableBlock.addCharge(machine, -this.getEnergyConsumption());
                inv.consumeItem(slot);
                ageable.setAge(ageable.getAge() + 1);
                crop.setBlockData((BlockData)ageable);
                crop.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, crop.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
                return true;
            }
        }
        return false;
    }
}

