/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.gadgets;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.core.attributes.Rechargeable;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SolarHelmet
extends SlimefunItem {
    private final ItemSetting<Double> charge;

    public SolarHelmet(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, double defaultChargingLevel) {
        super(category, item, recipeType, recipe);
        if (defaultChargingLevel <= 0.0) {
            throw new IllegalArgumentException("A Solar Helmet must have a positive charging level!");
        }
        this.charge = new ItemSetting<Double>("charge-amount", defaultChargingLevel);
        this.addItemSetting(this.charge);
    }

    public void rechargeItems(Player p) {
        this.recharge(p.getInventory().getHelmet());
        this.recharge(p.getInventory().getChestplate());
        this.recharge(p.getInventory().getLeggings());
        this.recharge(p.getInventory().getBoots());
        this.recharge(p.getInventory().getItemInMainHand());
        this.recharge(p.getInventory().getItemInOffHand());
    }

    private void recharge(ItemStack item) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem instanceof Rechargeable) {
            ((Rechargeable)((Object)sfItem)).addItemCharge(item, this.charge.getValue().floatValue());
        }
    }
}

