/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.ContributionsConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubConnector;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubIssuesTracker;
import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubTask;
import io.github.thebusybiscuit.slimefun4.core.services.localization.Translators;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kong.unirest.JsonNode;
import kong.unirest.json.JSONObject;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.bukkit.plugin.Plugin;

public class GitHubService {
    private final String repository;
    private final Set<GitHubConnector> connectors;
    private final ConcurrentMap<String, Contributor> contributors;
    private final Config uuidCache = new Config("plugins/Slimefun/cache/github/uuids.yml");
    private final Config texturesCache = new Config("plugins/Slimefun/cache/github/skins.yml");
    private boolean logging = false;
    private int issues = 0;
    private int pullRequests = 0;
    private int forks = 0;
    private int stars = 0;
    private LocalDateTime lastUpdate = LocalDateTime.now();

    public GitHubService(String repository) {
        this.repository = repository;
        this.connectors = new HashSet<GitHubConnector>();
        this.contributors = new ConcurrentHashMap<String, Contributor>();
        this.loadConnectors(false);
    }

    public void start(SlimefunPlugin plugin) {
        plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)plugin, (Runnable)new GitHubTask(this), 80L, 72000L);
    }

    private void addDefaultContributors() {
        this.addContributor("Fuffles_", "&dArtist");
        this.addContributor("IMS_Art", "&dArtist");
        this.addContributor("nahkd123", "&aWinner of the 2020 Addon Jam");
        new Translators(this);
    }

    private void addContributor(String name, String role) {
        Contributor contributor = new Contributor(name);
        contributor.setContribution(role, 0);
        contributor.setUniqueId(this.uuidCache.getUUID(name));
        this.contributors.put(name, contributor);
    }

    public Contributor addContributor(String minecraftName, String profile, String role, int commits) {
        String username = profile.substring(profile.lastIndexOf(47) + 1);
        Contributor contributor = this.contributors.computeIfAbsent(username, key -> new Contributor(minecraftName, profile));
        contributor.setContribution(role, commits);
        contributor.setUniqueId(this.uuidCache.getUUID(minecraftName));
        return contributor;
    }

    private void loadConnectors(boolean logging) {
        this.logging = logging;
        this.addDefaultContributors();
        this.connectors.add(new ContributionsConnector(this, "code", 1, this.repository, "developer"));
        this.connectors.add(new ContributionsConnector(this, "code2", 2, this.repository, "developer"));
        this.connectors.add(new ContributionsConnector(this, "wiki", 1, "Slimefun/Slimefun-wiki", "wiki"));
        this.connectors.add(new ContributionsConnector(this, "resourcepack", 1, "Slimefun/Resourcepack", "resourcepack"));
        this.connectors.add(new GitHubIssuesTracker(this, this.repository, (issues, pullRequests) -> {
            this.issues = issues;
            this.pullRequests = pullRequests;
        }));
        this.connectors.add(new GitHubConnector(this, this.repository){

            @Override
            public void onSuccess(JsonNode element) {
                JSONObject object = element.getObject();
                GitHubService.this.forks = object.getInt("forks");
                GitHubService.this.stars = object.getInt("stargazers_count");
                GitHubService.this.lastUpdate = NumberUtils.parseGitHubDate(object.getString("pushed_at"));
            }

            @Override
            public String getFileName() {
                return "repo";
            }

            @Override
            public String getURLSuffix() {
                return "";
            }
        });
    }

    protected Set<GitHubConnector> getConnectors() {
        return this.connectors;
    }

    protected boolean isLoggingEnabled() {
        return this.logging;
    }

    public ConcurrentMap<String, Contributor> getContributors() {
        return this.contributors;
    }

    public int getForks() {
        return this.forks;
    }

    public int getStars() {
        return this.stars;
    }

    public int getOpenissues() {
        return this.issues;
    }

    public String getRepository() {
        return this.repository;
    }

    public int getPendingPullRequests() {
        return this.pullRequests;
    }

    public LocalDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    protected void saveCache() {
        for (Contributor contributor : this.contributors.values()) {
            String texture;
            Optional<UUID> uuid = contributor.getUniqueId();
            uuid.ifPresent(value -> this.uuidCache.setValue(contributor.getName(), value));
            if (!contributor.hasTexture() || (texture = contributor.getTexture()).equals(HeadTexture.UNKNOWN.getTexture())) continue;
            this.texturesCache.setValue(contributor.getName(), texture);
        }
        this.uuidCache.save();
        this.texturesCache.save();
    }

    protected String getCachedTexture(String name) {
        return this.texturesCache.getString(name);
    }
}

