/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks;

import io.github.thebusybiscuit.slimefun4.api.network.Network;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;

public class NetworkManager {
    private final int maxNodes;
    private final List<Network> networks = new LinkedList<Network>();

    public NetworkManager(int maxStepSize) {
        Validate.isTrue((maxStepSize > 0 ? 1 : 0) != 0, (String)"The maximal Network size must be above zero!");
        this.maxNodes = maxStepSize;
    }

    public int getMaxSize() {
        return this.maxNodes;
    }

    public List<Network> getNetworkList() {
        return this.networks;
    }

    public <T extends Network> Optional<T> getNetworkFromLocation(Location l, Class<T> type) {
        if (l == null) {
            return Optional.empty();
        }
        Validate.notNull(type, (String)"Type must not be null");
        for (Network network : this.networks) {
            if (!type.isInstance(network) || !network.connectsTo(l)) continue;
            return Optional.of(type.cast(network));
        }
        return Optional.empty();
    }

    public <T extends Network> List<T> getNetworksFromLocation(Location l, Class<T> type) {
        if (l == null) {
            return new ArrayList();
        }
        Validate.notNull(type, (String)"Type must not be null");
        ArrayList<T> list = new ArrayList<T>();
        for (Network network : this.networks) {
            if (!type.isInstance(network) || !network.connectsTo(l)) continue;
            list.add(type.cast(network));
        }
        return list;
    }

    public void registerNetwork(Network network) {
        Validate.notNull((Object)network, (String)"Cannot register a null Network");
        this.networks.add(network);
    }

    public void unregisterNetwork(Network network) {
        Validate.notNull((Object)network, (String)"Cannot unregister a null Network");
        this.networks.remove(network);
    }

    public void updateAllNetworks(Location l) {
        for (Network network : this.getNetworksFromLocation(l, Network.class)) {
            network.markDirty(l);
        }
    }
}

