/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoNet;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

class CargoNetworkTask
implements Runnable {
    private final CargoNet network;
    private final Map<Location, Inventory> inventories = new HashMap<Location, Inventory>();
    private final Map<Location, Integer> inputs;
    private final Map<Integer, List<Location>> outputs;
    private final Set<Location> chestTerminalInputs;
    private final Set<Location> chestTerminalOutputs;

    CargoNetworkTask(CargoNet network, Map<Location, Integer> inputs, Map<Integer, List<Location>> outputs, Set<Location> chestTerminalInputs, Set<Location> chestTerminalOutputs) {
        this.network = network;
        this.inputs = inputs;
        this.outputs = outputs;
        this.chestTerminalInputs = chestTerminalInputs;
        this.chestTerminalOutputs = chestTerminalOutputs;
    }

    @Override
    public void run() {
        long timestamp = System.nanoTime();
        if (SlimefunPlugin.getThirdPartySupportService().isChestTerminalInstalled()) {
            this.network.handleItemRequests(this.inventories, this.chestTerminalInputs, this.chestTerminalOutputs);
        }
        for (Map.Entry<Location, Integer> entry : this.inputs.entrySet()) {
            long nodeTimestamp = System.nanoTime();
            Location input = entry.getKey();
            Optional<Block> attachedBlock = this.network.getAttachedBlock(input);
            if (attachedBlock.isPresent()) {
                this.routeItems(input, attachedBlock.get(), entry.getValue(), this.outputs);
            }
            timestamp += SlimefunPlugin.getProfiler().closeEntry(entry.getKey(), SlimefunItems.CARGO_INPUT_NODE.getItem(), nodeTimestamp);
        }
        if (SlimefunPlugin.getThirdPartySupportService().isChestTerminalInstalled()) {
            this.network.updateTerminals(this.chestTerminalInputs);
        }
        SlimefunPlugin.getProfiler().closeEntry(this.network.getRegulator(), SlimefunItems.CARGO_MANAGER.getItem(), timestamp);
    }

    private void routeItems(Location inputNode, Block inputTarget, int frequency, Map<Integer, List<Location>> outputNodes) {
        ItemStackAndInteger slot = CargoUtils.withdraw(this.inventories, inputNode.getBlock(), inputTarget);
        if (slot == null) {
            return;
        }
        ItemStack stack = slot.getItem();
        int previousSlot = slot.getInt();
        List<Location> destinations = outputNodes.get(frequency);
        if (destinations != null) {
            stack = this.distributeItem(stack, inputNode, destinations);
        }
        if (stack != null) {
            Inventory inv = this.inventories.get(inputTarget.getLocation());
            if (inv != null) {
                if (inv.getItem(previousSlot) == null) {
                    inv.setItem(previousSlot, stack);
                } else {
                    inputTarget.getWorld().dropItem(inputTarget.getLocation().add(0.0, 1.0, 0.0), stack);
                }
            } else {
                DirtyChestMenu menu = CargoUtils.getChestMenu(inputTarget);
                if (menu != null) {
                    if (menu.getItemInSlot(previousSlot) == null) {
                        menu.replaceExistingItem(previousSlot, stack);
                    } else {
                        inputTarget.getWorld().dropItem(inputTarget.getLocation().add(0.0, 1.0, 0.0), stack);
                    }
                }
            }
        }
    }

    private ItemStack distributeItem(ItemStack stack, Location inputNode, List<Location> outputNodes) {
        Location output;
        Optional<Block> target;
        ItemStack item = stack;
        LinkedList<Location> destinations = new LinkedList<Location>(outputNodes);
        Config cfg = BlockStorage.getLocationInfo(inputNode);
        boolean roundrobin = "true".equals(cfg.getString("round-robin"));
        if (roundrobin) {
            this.roundRobinSort(inputNode, destinations);
        }
        Iterator iterator = destinations.iterator();
        while (iterator.hasNext() && (!(target = this.network.getAttachedBlock(output = (Location)iterator.next())).isPresent() || (item = CargoUtils.insert(this.inventories, output.getBlock(), target.get(), item)) != null)) {
        }
        return item;
    }

    private void roundRobinSort(Location inputNode, Deque<Location> outputNodes) {
        int index = this.network.roundRobin.getOrDefault(inputNode, 0);
        if (index < outputNodes.size()) {
            for (int i = 0; i < index; ++i) {
                Location temp = outputNodes.removeFirst();
                outputNodes.add(temp);
            }
            ++index;
        } else {
            index = 1;
        }
        this.network.roundRobin.put(inputNode, index);
    }
}

