/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide.options;

import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.core.services.github.Contributor;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

final class ContributorsMenu {
    private ContributorsMenu() {
    }

    public static void open(Player p, int page) {
        ChestMenu menu = new ChestMenu(SlimefunPlugin.getLocalization().getMessage(p, "guide.title.credits"));
        menu.setEmptySlotsClickable(false);
        menu.addMenuOpeningHandler(pl -> pl.playSound(pl.getLocation(), Sound.BLOCK_NOTE_BLOCK_HARP, 0.7f, 0.7f));
        ChestMenuUtils.drawBackground(menu, 0, 2, 3, 4, 5, 6, 7, 8, 45, 47, 48, 49, 50, 51, 52);
        menu.addItem(1, (ItemStack)new CustomItem(ChestMenuUtils.getBackButton(p, "", "&7" + SlimefunPlugin.getLocalization().getMessage(p, "guide.back.settings"))));
        menu.addMenuClickHandler(1, (pl, slot, item, action) -> {
            SlimefunGuideSettings.openSettings(pl, p.getInventory().getItemInMainHand());
            return false;
        });
        ArrayList contributors = new ArrayList(SlimefunPlugin.getGitHubService().getContributors().values());
        contributors.sort(Comparator.comparingInt(Contributor::index));
        for (int i = page * 36; i < contributors.size() && i < (page + 1) * 36; ++i) {
            Contributor contributor = (Contributor)contributors.get(i);
            ItemStack skull = ContributorsMenu.getContributorHead(p, contributor);
            menu.addItem(i - page * 36 + 9, skull);
            menu.addMenuClickHandler(i - page * 36 + 9, (pl, slot, item, action) -> {
                if (contributor.getProfile() != null) {
                    pl.closeInventory();
                    ChatUtils.sendURL((CommandSender)pl, contributor.getProfile());
                }
                return false;
            });
        }
        int pages = (contributors.size() - 1) / 36 + 1;
        menu.addItem(46, ChestMenuUtils.getPreviousButton(p, page + 1, pages));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            if (page > 0) {
                ContributorsMenu.open(pl, page - 1);
            }
            return false;
        });
        menu.addItem(52, ChestMenuUtils.getNextButton(p, page + 1, pages));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            if (page + 1 < pages) {
                ContributorsMenu.open(pl, page + 1);
            }
            return false;
        });
        menu.open(new Player[]{p});
    }

    private static ItemStack getContributorHead(Player p, Contributor contributor) {
        ItemStack skull = SlimefunUtils.getCustomHead(contributor.getTexture());
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setDisplayName(contributor.getDisplayName());
        LinkedList<String> lore = new LinkedList<String>();
        lore.add("");
        for (Map.Entry<String, Integer> entry : contributor.getContributions()) {
            String info = entry.getKey();
            if (!info.startsWith("&")) {
                String[] segments = PatternUtils.COMMA.split(info);
                info = SlimefunPlugin.getLocalization().getMessage(p, "guide.credits.roles." + segments[0]);
                if (segments.length == 2) {
                    info = info + " &7(" + SlimefunPlugin.getLocalization().getMessage(p, "languages." + segments[1]) + ')';
                }
            }
            if (entry.getValue() > 0) {
                String commits = SlimefunPlugin.getLocalization().getMessage(p, "guide.credits." + (entry.getValue() > 1 ? "commits" : "commit"));
                info = info + " &7(" + entry.getValue() + ' ' + commits + ')';
            }
            lore.add(ChatColors.color(info));
        }
        if (contributor.getProfile() != null) {
            lore.add("");
            lore.add(ChatColors.color("&7\u21e8 &e") + SlimefunPlugin.getLocalization().getMessage(p, "guide.credits.profile-link"));
        }
        meta.setLore(lore);
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }
}

